/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.util;

import com.linkedin.data.Data;
import com.linkedin.data.DataMap;
import com.linkedin.restli.client.DeleteRequest;
import com.linkedin.restli.client.FindRequest;
import com.linkedin.restli.client.GetAllRequest;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.PartialUpdateRequest;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.UpdateRequest;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.client.QueryParamsUtil;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class RestliRequestUriSignature {
    public static final Set<SignatureField> ALL_FIELDS = Collections.unmodifiableSet(new HashSet<SignatureField>(Arrays.asList(SignatureField.values())));
    private final Set<SignatureField> _maskFields;
    private final String _baseUriTemplate;
    private final Map<String, Object> _pathKeys;
    private final Object _id;
    private final Map<String, Object> _queryParams;
    private final Map<String, Class<?>> _queryParamClasses;

    public RestliRequestUriSignature(Request<?> request, Set<SignatureField> maskFields) {
        CompoundKey assocKey;
        if (maskFields.isEmpty()) {
            throw new IllegalArgumentException("Signature fields must include at least one field.");
        }
        this._maskFields = maskFields;
        this._baseUriTemplate = maskFields.contains((Object)SignatureField.BASE_URI_TEMPLATE) ? request.getBaseUriTemplate() : null;
        this._pathKeys = maskFields.contains((Object)SignatureField.PATH_KEYS) ? request.getPathKeys() : null;
        this._id = !maskFields.contains((Object)SignatureField.ID) ? null : (request instanceof GetRequest ? ((GetRequest)request).getObjectId() : (request instanceof UpdateRequest ? ((UpdateRequest)request).getId() : (request instanceof PartialUpdateRequest ? ((PartialUpdateRequest)request).getId() : (request instanceof DeleteRequest ? ((DeleteRequest)request).getId() : (request instanceof FindRequest ? ((assocKey = ((FindRequest)request).getAssocKey()).getNumParts() == 0 ? null : assocKey) : (request instanceof GetAllRequest ? ((assocKey = ((GetAllRequest)request).getAssocKey()).getNumParts() == 0 ? null : assocKey) : null))))));
        if (maskFields.contains((Object)SignatureField.QUERY_PARAMS)) {
            Map<String, Object> rawQueryParams = request.getQueryParamsObjects();
            if (rawQueryParams == null) {
                this._queryParams = null;
                this._queryParamClasses = null;
            } else {
                this._queryParams = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : rawQueryParams.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        this._queryParams.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
                        continue;
                    }
                    this._queryParams.put(entry.getKey(), entry.getValue());
                }
                this._queryParamClasses = request.getQueryParamClasses();
            }
        } else {
            this._queryParams = null;
            this._queryParamClasses = null;
        }
    }

    public Set<SignatureField> getMaskFields() {
        return this._maskFields;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._baseUriTemplate).append(this._pathKeys).append(this._id).append(this._queryParams).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestliRequestUriSignature other = (RestliRequestUriSignature)obj;
        return new EqualsBuilder().append((Object)this._baseUriTemplate, (Object)other._baseUriTemplate).append(this._pathKeys, other._pathKeys).append(this._id, other._id).append(this._queryParams, other._queryParams).isEquals();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE).append("baseUriTemplate", (Object)this._baseUriTemplate).append("pathKeys", this._pathKeys).append("id", this._id).append("queryParams", this._queryParams);
        return builder.toString();
    }

    public String dump() {
        ProtocolVersion protocolVersion = AllProtocolVersions.LATEST_PROTOCOL_VERSION;
        DataMap pathKeysMap = new DataMap(URIParamUtils.encodePathKeysForUri(this._pathKeys, (ProtocolVersion)protocolVersion));
        DataMap queryParamsMap = QueryParamsUtil.convertToDataMap(this._queryParams, this._queryParamClasses, protocolVersion);
        ToStringBuilder builder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE).append("baseUriTemplate", (Object)this._baseUriTemplate).append("pathKeys", (Object)Data.dump((String)"", (Object)pathKeysMap, (String)"")).append("id", this._id).append("queryParams", (Object)Data.dump((String)"", (Object)queryParamsMap, (String)""));
        return builder.toString();
    }

    public static enum SignatureField {
        BASE_URI_TEMPLATE,
        PATH_KEYS,
        ID,
        QUERY_PARAMS;

    }
}

