/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.ResponseUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BatchKVResponse<K, V extends RecordTemplate>
extends RecordTemplate {
    public static final String RESULTS = "results";
    public static final String ERRORS = "errors";
    private RecordDataSchema _schema;
    private Class<V> _valueClass;
    private Map<K, V> _results;
    private Map<K, ErrorResponse> _errors;

    public BatchKVResponse(DataMap data, Class<K> keyClass, Class<V> valueClass, Map<String, CompoundKey.TypeInfo> keyParts, ProtocolVersion version) {
        this(data, keyClass, valueClass, keyParts, null, null, version);
    }

    @Deprecated
    public BatchKVResponse(DataMap data, Class<K> keyClass, Class<V> valueClass, Map<String, CompoundKey.TypeInfo> keyParts) {
        this(data, keyClass, valueClass, keyParts, AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public BatchKVResponse(DataMap data, TypeSpec<K> keyType, TypeSpec<V> valueType, Map<String, CompoundKey.TypeInfo> keyParts, ProtocolVersion version) {
        this(data, keyType, valueType, keyParts, null, version);
    }

    @Deprecated
    public BatchKVResponse(DataMap data, TypeSpec<K> keyType, TypeSpec<V> valueType, Map<String, CompoundKey.TypeInfo> keyParts) {
        this(data, keyType, valueType, keyParts, AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public BatchKVResponse(DataMap data, Class<K> keyClass, Class<V> valueClass, Map<String, CompoundKey.TypeInfo> keyParts, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, ProtocolVersion version) {
        this(data, TypeSpec.forClassMaybeNull(keyClass), TypeSpec.forClassMaybeNull(valueClass), keyParts, ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass), version);
    }

    @Deprecated
    public BatchKVResponse(DataMap data, Class<K> keyClass, Class<V> valueClass, Map<String, CompoundKey.TypeInfo> keyParts, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass) {
        this(data, keyClass, valueClass, keyParts, keyKeyClass, keyParamsClass, AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public BatchKVResponse(DataMap data, TypeSpec<K> keyType, TypeSpec<V> valueType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        super(data, null);
        this.createSchema(valueType.getType());
        this.deserializeData(keyType, keyParts, complexKeyType, version);
    }

    @Deprecated
    public BatchKVResponse(DataMap data, TypeSpec<K> keyType, TypeSpec<V> valueType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType) {
        this(data, keyType, valueType, keyParts, complexKeyType, AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    protected BatchKVResponse(DataMap data) {
        super(data, null);
    }

    protected void createSchema(Class<V> valueClass) {
        this._valueClass = valueClass;
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        Name elementSchemaName = new Name(valueClass.getSimpleName(), errorMessageBuilder);
        MapDataSchema resultsSchema = new MapDataSchema((DataSchema)new RecordDataSchema(elementSchemaName, RecordDataSchema.RecordType.RECORD));
        RecordDataSchema.Field resultsField = new RecordDataSchema.Field((DataSchema)resultsSchema);
        resultsField.setName(RESULTS, errorMessageBuilder);
        Name errorSchemaName = new Name(ErrorResponse.class.getSimpleName(), errorMessageBuilder);
        MapDataSchema errorsSchema = new MapDataSchema((DataSchema)new RecordDataSchema(errorSchemaName, RecordDataSchema.RecordType.RECORD));
        RecordDataSchema.Field errorsField = new RecordDataSchema.Field((DataSchema)errorsSchema);
        errorsField.setName(ERRORS, errorMessageBuilder);
        Name name = new Name(BatchKVResponse.class.getSimpleName(), errorMessageBuilder);
        this._schema = new RecordDataSchema(name, RecordDataSchema.RecordType.RECORD);
        this._schema.setFields(Arrays.asList(resultsField, errorsField), errorMessageBuilder);
    }

    protected void deserializeData(TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        this.deserializeData(this.data(), keyType, keyParts, complexKeyType, version);
    }

    protected void deserializeData(DataMap data, TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        DataMap resultsRaw = data.getDataMap(RESULTS);
        if (resultsRaw == null) {
            this._results = new ParamlessKeyHashMap<V>(complexKeyType);
        } else {
            this._results = new ParamlessKeyHashMap<V>(CollectionUtils.getMapInitialCapacity((int)resultsRaw.size(), (float)0.75f), 0.75f, complexKeyType);
            for (Map.Entry entry : resultsRaw.entrySet()) {
                Object key = ResponseUtils.convertKey((String)((String)entry.getKey()), keyType, keyParts, complexKeyType, (ProtocolVersion)version);
                V value = this.deserializeValue(entry.getValue());
                this._results.put(key, value);
            }
        }
        DataMap errorsRaw = data.getDataMap(ERRORS);
        if (errorsRaw == null) {
            this._errors = new ParamlessKeyHashMap<ErrorResponse>(complexKeyType);
        } else {
            this._errors = new ParamlessKeyHashMap<ErrorResponse>(CollectionUtils.getMapInitialCapacity((int)errorsRaw.size(), (float)0.75f), 0.75f, complexKeyType);
            for (Map.Entry entry : errorsRaw.entrySet()) {
                Object key = ResponseUtils.convertKey((String)((String)entry.getKey()), keyType, keyParts, complexKeyType, (ProtocolVersion)version);
                ErrorResponse value = (ErrorResponse)DataTemplateUtil.wrap(entry.getValue(), ErrorResponse.class);
                this._errors.put(key, value);
            }
        }
    }

    public Map<K, V> getResults() {
        return this._results;
    }

    public Map<K, ErrorResponse> getErrors() {
        return this._errors;
    }

    public RecordDataSchema schema() {
        return this._schema;
    }

    protected V deserializeValue(Object valueData) {
        return (V)((RecordTemplate)DataTemplateUtil.wrap((Object)valueData, this._valueClass));
    }

    private class ParamlessKeyHashMap<MV>
    extends HashMap<K, MV> {
        private static final long serialVersionUID = 1L;
        private final ComplexKeySpec<?, ?> _complexKeyType;

        private ParamlessKeyHashMap(ComplexKeySpec<?, ?> complexKeyType) {
            this._complexKeyType = complexKeyType;
        }

        private ParamlessKeyHashMap(int initialCapacity, float loadFactor, ComplexKeySpec<?, ?> complexKeyType) {
            super(initialCapacity, loadFactor);
            this._complexKeyType = complexKeyType;
        }

        @Override
        public MV get(Object key) {
            return (MV)super.get(this.getProcessedKey(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(this.getProcessedKey(key));
        }

        @Override
        public MV put(K key, MV value) {
            return super.put(this.getProcessedKey(key), value);
        }

        @Override
        public MV remove(Object key) {
            return (MV)super.remove(this.getProcessedKey(key));
        }

        private <MK> MK getProcessedKey(MK key) {
            if (key instanceof ComplexResourceKey) {
                ComplexResourceKey complexKey = (ComplexResourceKey)key;
                return (MK)new ComplexResourceKey(complexKey.getKey(), (RecordTemplate)DataTemplateUtil.wrap((Object)new DataMap(), (Class)this._complexKeyType.getParamsType().getType()));
            }
            return key;
        }
    }
}

