/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.r2.filter.CompressionOption;
import com.linkedin.restli.client.ProtocolVersionOption;
import com.linkedin.restli.client.RestClient;
import com.linkedin.restli.client.RestliRequestOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RestliRequestOptionsBuilder {
    private ProtocolVersionOption _protocolVersionOption;
    private CompressionOption _requestCompressionOverride;
    private RestClient.ContentType _contentType;
    private List<RestClient.AcceptType> _acceptTypes;
    private CompressionOption _responseCompressionOverride;
    private boolean _acceptResponseAttachments = false;

    public RestliRequestOptionsBuilder() {
    }

    public RestliRequestOptionsBuilder(RestliRequestOptions restliRequestOptions) {
        this.setProtocolVersionOption(restliRequestOptions.getProtocolVersionOption());
        this.setRequestCompressionOverride(restliRequestOptions.getRequestCompressionOverride());
        this.setResponseCompressionOverride(restliRequestOptions.getResponseCompressionOverride());
        this.setContentType(restliRequestOptions.getContentType());
        this.setAcceptTypes(restliRequestOptions.getAcceptTypes());
        this.setAcceptResponseAttachments(restliRequestOptions.getAcceptResponseAttachments());
    }

    public RestliRequestOptionsBuilder setProtocolVersionOption(ProtocolVersionOption protocolVersionOption) {
        this._protocolVersionOption = protocolVersionOption;
        return this;
    }

    public RestliRequestOptionsBuilder setRequestCompressionOverride(CompressionOption requestCompressionOverride) {
        this._requestCompressionOverride = requestCompressionOverride;
        return this;
    }

    public RestliRequestOptionsBuilder setContentType(RestClient.ContentType contentType) {
        this._contentType = contentType;
        return this;
    }

    public RestliRequestOptionsBuilder setAcceptTypes(List<RestClient.AcceptType> acceptTypes) {
        if (acceptTypes != null) {
            this._acceptTypes = new ArrayList<RestClient.AcceptType>(acceptTypes);
        }
        return this;
    }

    public RestliRequestOptionsBuilder addAcceptTypes(List<RestClient.AcceptType> acceptTypes) {
        if (this._acceptTypes == null) {
            return this.setAcceptTypes(acceptTypes);
        }
        for (RestClient.AcceptType acceptType : acceptTypes) {
            if (this._acceptTypes.contains((Object)acceptType)) continue;
            this._acceptTypes.add(acceptType);
        }
        return this;
    }

    public RestliRequestOptionsBuilder addAcceptType(RestClient.AcceptType acceptType) {
        if (this._acceptTypes == null) {
            this._acceptTypes = new ArrayList<RestClient.AcceptType>();
        }
        if (!this._acceptTypes.contains((Object)acceptType)) {
            this._acceptTypes.add(acceptType);
        }
        return this;
    }

    public RestliRequestOptionsBuilder setResponseCompressionOverride(CompressionOption responseCompressionOverride) {
        this._responseCompressionOverride = responseCompressionOverride;
        return this;
    }

    public RestliRequestOptionsBuilder setAcceptResponseAttachments(boolean acceptResponseAttachments) {
        this._acceptResponseAttachments = acceptResponseAttachments;
        return this;
    }

    public RestliRequestOptions build() {
        return new RestliRequestOptions(this._protocolVersionOption, this._requestCompressionOverride, this._responseCompressionOverride, this._contentType, this._acceptTypes != null ? Collections.unmodifiableList(this._acceptTypes) : null, this._acceptResponseAttachments);
    }

    public ProtocolVersionOption getProtocolVersionOption() {
        return this._protocolVersionOption;
    }

    public CompressionOption getRequestCompressionOverride() {
        return this._requestCompressionOverride;
    }

    public RestClient.ContentType getContentType() {
        return this._contentType;
    }

    public List<RestClient.AcceptType> getAcceptTypes() {
        return this._acceptTypes != null ? Collections.unmodifiableList(this._acceptTypes) : null;
    }

    public CompressionOption getResponseCompressionOverride() {
        return this._responseCompressionOverride;
    }

    public boolean isAcceptResponseAttachments() {
        return this._acceptResponseAttachments;
    }
}

