/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.r2.filter.CompressionOption;
import com.linkedin.restli.client.ProtocolVersionOption;
import com.linkedin.restli.client.RestClient;
import java.util.List;

public class RestliRequestOptions {
    private final ProtocolVersionOption _protocolVersionOption;
    private final CompressionOption _requestCompressionOverride;
    private final CompressionOption _responseCompressionOverride;
    private final RestClient.ContentType _contentType;
    private final List<RestClient.AcceptType> _acceptTypes;
    private final boolean _acceptResponseAttachments;
    public static final RestliRequestOptions DEFAULT_OPTIONS = new RestliRequestOptions(ProtocolVersionOption.USE_LATEST_IF_AVAILABLE, null, null, null, null, false);
    public static final RestliRequestOptions FORCE_USE_NEXT_OPTION = new RestliRequestOptions(ProtocolVersionOption.FORCE_USE_NEXT, null, null, null, null, false);
    public static final RestliRequestOptions FORCE_USE_PREV_OPTION = new RestliRequestOptions(ProtocolVersionOption.FORCE_USE_PREVIOUS, null, null, null, null, false);

    RestliRequestOptions(ProtocolVersionOption protocolVersionOption, CompressionOption requestCompressionOverride, CompressionOption responseCompressionOverride, RestClient.ContentType contentType, List<RestClient.AcceptType> acceptTypes, boolean acceptResponseAttachments) {
        this._protocolVersionOption = protocolVersionOption == null ? ProtocolVersionOption.USE_LATEST_IF_AVAILABLE : protocolVersionOption;
        this._requestCompressionOverride = requestCompressionOverride;
        this._responseCompressionOverride = responseCompressionOverride;
        this._contentType = contentType;
        this._acceptTypes = acceptTypes;
        this._acceptResponseAttachments = acceptResponseAttachments;
    }

    public ProtocolVersionOption getProtocolVersionOption() {
        return this._protocolVersionOption;
    }

    public CompressionOption getRequestCompressionOverride() {
        return this._requestCompressionOverride;
    }

    public List<RestClient.AcceptType> getAcceptTypes() {
        return this._acceptTypes;
    }

    public RestClient.ContentType getContentType() {
        return this._contentType;
    }

    public CompressionOption getResponseCompressionOverride() {
        return this._responseCompressionOverride;
    }

    public boolean getAcceptResponseAttachments() {
        return this._acceptResponseAttachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestliRequestOptions that = (RestliRequestOptions)o;
        if (this._acceptResponseAttachments != that._acceptResponseAttachments) {
            return false;
        }
        if (this._acceptTypes != null ? !this._acceptTypes.equals(that._acceptTypes) : that._acceptTypes != null) {
            return false;
        }
        if (this._contentType != that._contentType) {
            return false;
        }
        if (this._protocolVersionOption != that._protocolVersionOption) {
            return false;
        }
        if (this._requestCompressionOverride != that._requestCompressionOverride) {
            return false;
        }
        return this._responseCompressionOverride == that._responseCompressionOverride;
    }

    public int hashCode() {
        int result = this._protocolVersionOption.hashCode();
        result = 31 * result + (this._requestCompressionOverride != null ? this._requestCompressionOverride.hashCode() : 0);
        result = 31 * result + (this._responseCompressionOverride != null ? this._responseCompressionOverride.hashCode() : 0);
        result = 31 * result + (this._contentType != null ? this._contentType.hashCode() : 0);
        result = 31 * result + (this._acceptTypes != null ? this._acceptTypes.hashCode() : 0);
        result = 31 * result + (this._acceptResponseAttachments ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RestliRequestOptions{_protocolVersionOption=" + (Object)((Object)this._protocolVersionOption) + ", _requestCompressionOverride=" + this._requestCompressionOverride + ", _responseCompressionOverride=" + this._responseCompressionOverride + ", _contentType=" + (Object)((Object)this._contentType) + ", _acceptTypes=" + this._acceptTypes + ", _acceptResponseAttachments=" + this._acceptResponseAttachments + '}';
    }
}

