/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.restli.client.BatchKVRequestBuilder;
import com.linkedin.restli.client.BatchUpdateRequest;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.common.KeyValueRecord;
import com.linkedin.restli.common.KeyValueRecordFactory;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUpdateRequestBuilder<K, V extends RecordTemplate>
extends BatchKVRequestBuilder<K, V, BatchUpdateRequest<K, V>> {
    private final KeyValueRecordFactory<K, V> _keyValueRecordFactory;
    private final Map<K, V> _updateInputMap;
    private List<Object> _streamingAttachments;

    public BatchUpdateRequestBuilder(String baseUriTemplate, Class<V> valueClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._keyValueRecordFactory = new KeyValueRecordFactory(this._resourceSpec.getKeyType(), this._resourceSpec.getComplexKeyType(), this._resourceSpec.getKeyParts(), this._resourceSpec.getValueType());
        this._updateInputMap = new HashMap();
    }

    public BatchUpdateRequestBuilder<K, V> input(K id, V entity) {
        this.addKey(id);
        this._updateInputMap.put(id, entity);
        return this;
    }

    public BatchUpdateRequestBuilder<K, V> inputs(Map<K, V> entities) {
        this.addKeys(entities.keySet());
        for (Map.Entry<K, V> entry : entities.entrySet()) {
            K key = entry.getKey();
            RecordTemplate value = (RecordTemplate)entry.getValue();
            this._updateInputMap.put(key, value);
        }
        return this;
    }

    public BatchUpdateRequestBuilder<K, V> appendSingleAttachment(RestLiAttachmentDataSourceWriter streamingAttachment) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(streamingAttachment);
        return this;
    }

    public BatchUpdateRequestBuilder<K, V> appendMultipleAttachments(RestLiDataSourceIterator dataSourceIterator) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(dataSourceIterator);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> setParam(String key, Object value) {
        super.setParam(key, value);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> setReqParam(String key, Object value) {
        super.setReqParam(key, value);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> addParam(String key, Object value) {
        super.addParam(key, value);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> addReqParam(String key, Object value) {
        super.addReqParam(key, value);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public BatchUpdateRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders((Map)headers);
        return this;
    }

    @Override
    public BatchUpdateRequestBuilder<K, V> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public BatchUpdateRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    @Override
    public BatchUpdateRequest<K, V> build() {
        this.ensureBatchKeys();
        HashMap readOnlyUpdateInputMap = new HashMap(CollectionUtils.getMapInitialCapacity((int)this._updateInputMap.size(), (float)0.75f), 0.75f);
        CollectionRequest readOnlyInput = this.buildReadOnlyBatchUpdateInput(readOnlyUpdateInputMap);
        return new BatchUpdateRequest(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), readOnlyInput, this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this._resourceSpec, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions(), Collections.unmodifiableMap(readOnlyUpdateInputMap), this._streamingAttachments == null ? null : Collections.unmodifiableList(this._streamingAttachments));
    }

    private CollectionRequest<KeyValueRecord<K, V>> buildReadOnlyBatchUpdateInput(Map<K, V> readOnlyInputEntities) {
        try {
            DataMap map = new DataMap();
            CollectionRequest input = new CollectionRequest(map, KeyValueRecord.class);
            for (Map.Entry<K, V> inputEntityEntry : this._updateInputMap.entrySet()) {
                K key = this.getReadOnlyOrCopyKey(inputEntityEntry.getKey());
                RecordTemplate entity = (RecordTemplate)this.getReadOnlyOrCopyDataTemplate((DataTemplate)inputEntityEntry.getValue());
                readOnlyInputEntities.put(key, entity);
                KeyValueRecord keyValueRecord = this._keyValueRecordFactory.create(key, entity);
                keyValueRecord.data().setReadOnly();
                input.getElements().add(keyValueRecord);
            }
            map.setReadOnly();
            return input;
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Entity cannot be copied.", cloneException);
        }
    }
}

