/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.BatchKVRequestBuilder;
import com.linkedin.restli.client.BatchPartialUpdateRequest;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.common.KeyValueRecord;
import com.linkedin.restli.common.KeyValueRecordFactory;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchPartialUpdateRequestBuilder<K, V extends RecordTemplate>
extends BatchKVRequestBuilder<K, V, BatchPartialUpdateRequest<K, V>> {
    private final KeyValueRecordFactory<K, PatchRequest<V>> _keyValueRecordFactory;
    private final Map<K, PatchRequest<V>> _partialUpdateInputMap = new HashMap<K, PatchRequest<V>>();
    private List<Object> _streamingAttachments;

    public BatchPartialUpdateRequestBuilder(String baseUriTemplate, Class<V> valueClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._keyValueRecordFactory = new KeyValueRecordFactory(this._resourceSpec.getKeyType(), this._resourceSpec.getComplexKeyType(), this._resourceSpec.getKeyParts(), new TypeSpec(PatchRequest.class));
    }

    public BatchPartialUpdateRequestBuilder<K, V> input(K id, PatchRequest<V> patch) {
        this._partialUpdateInputMap.put(id, patch);
        this.addKey(id);
        return this;
    }

    public BatchPartialUpdateRequestBuilder<K, V> inputs(Map<K, PatchRequest<V>> patches) {
        this.addKeys(patches.keySet());
        for (Map.Entry<K, PatchRequest<V>> entry : patches.entrySet()) {
            K key = entry.getKey();
            PatchRequest<V> value = entry.getValue();
            this._partialUpdateInputMap.put(key, value);
        }
        return this;
    }

    public BatchPartialUpdateRequestBuilder<K, V> appendSingleAttachment(RestLiAttachmentDataSourceWriter streamingAttachment) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(streamingAttachment);
        return this;
    }

    public BatchPartialUpdateRequestBuilder<K, V> appendMultipleAttachments(RestLiDataSourceIterator dataSourceIterator) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(dataSourceIterator);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> setParam(String key, Object value) {
        super.setParam(key, value);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> setReqParam(String key, Object value) {
        super.setReqParam(key, value);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> addParam(String key, Object value) {
        super.addParam(key, value);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> addReqParam(String key, Object value) {
        super.addReqParam(key, value);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public BatchPartialUpdateRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders((Map)headers);
        return this;
    }

    @Override
    public BatchPartialUpdateRequestBuilder<K, V> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public BatchPartialUpdateRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    @Override
    public BatchPartialUpdateRequest<K, V> build() {
        this.ensureBatchKeys();
        return new BatchPartialUpdateRequest<K, V>(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), this.buildReadOnlyInput(), this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this._resourceSpec, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions(), this._streamingAttachments == null ? null : Collections.unmodifiableList(this._streamingAttachments));
    }

    private CollectionRequest<KeyValueRecord<K, PatchRequest<V>>> buildReadOnlyInput() {
        try {
            DataMap map = new DataMap();
            CollectionRequest input = new CollectionRequest(map, KeyValueRecord.class);
            for (Map.Entry<K, PatchRequest<V>> inputEntityEntry : this._partialUpdateInputMap.entrySet()) {
                K key = this.getReadOnlyOrCopyKey(inputEntityEntry.getKey());
                PatchRequest entity = (PatchRequest)this.getReadOnlyOrCopyDataTemplate((DataTemplate)inputEntityEntry.getValue());
                KeyValueRecord keyValueRecord = this._keyValueRecordFactory.create(key, (RecordTemplate)entity);
                keyValueRecord.data().setReadOnly();
                input.getElements().add(keyValueRecord);
            }
            map.setReadOnly();
            return input;
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Entity cannot be copied.", cloneException);
        }
    }
}

