/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldPrimitiveTypes<T>
extends AbstractBeanField<T> {
    private final boolean required;
    private final String locale;

    public BeanFieldPrimitiveTypes(Field field, boolean required, String locale) {
        super(field);
        this.required = required;
        this.locale = locale;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        Object o;
        block31: {
            if (this.required && StringUtils.isBlank((CharSequence)value)) {
                throw new CsvRequiredFieldEmptyException(String.format("Field '%s' is mandatory but no value was provided.", this.field.getName()));
            }
            o = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Class<String> fieldType = this.field.getType();
                try {
                    if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                        BooleanConverter c = new BooleanConverter();
                        o = c.convert(Boolean.class, (Object)value.trim());
                        break block31;
                    }
                    if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            ByteConverter c = new ByteConverter();
                            o = c.convert(Byte.class, (Object)value.trim());
                        } else {
                            ByteLocaleConverter c = new ByteLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            DoubleConverter c = new DoubleConverter();
                            o = c.convert(Double.class, (Object)value.trim());
                        } else {
                            DoubleLocaleConverter c = new DoubleLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            FloatConverter c = new FloatConverter();
                            o = c.convert(Float.class, (Object)value.trim());
                        } else {
                            FloatLocaleConverter c = new FloatLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            IntegerConverter c = new IntegerConverter();
                            o = c.convert(Integer.class, (Object)value.trim());
                        } else {
                            IntegerLocaleConverter c = new IntegerLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            LongConverter c = new LongConverter();
                            o = c.convert(Long.class, (Object)value.trim());
                        } else {
                            LongLocaleConverter c = new LongLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            ShortConverter c = new ShortConverter();
                            o = c.convert(Short.class, (Object)value.trim());
                        } else {
                            ShortLocaleConverter c = new ShortLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Character.TYPE) || fieldType.equals(Character.class)) {
                        CharacterConverter c = new CharacterConverter();
                        o = c.convert(Character.class, (Object)Character.valueOf(value.charAt(0)));
                        break block31;
                    }
                    if (fieldType.equals(BigDecimal.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            BigDecimalConverter c = new BigDecimalConverter();
                            o = c.convert(BigDecimal.class, (Object)value.trim());
                        } else {
                            BigDecimalLocaleConverter c = new BigDecimalLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(BigInteger.class)) {
                        if (StringUtils.isEmpty((CharSequence)this.locale)) {
                            BigIntegerConverter c = new BigIntegerConverter();
                            o = c.convert(BigInteger.class, (Object)value.trim());
                        } else {
                            BigIntegerLocaleConverter c = new BigIntegerLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert((Object)value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.isAssignableFrom(String.class)) {
                        o = value;
                        break block31;
                    }
                    throw new CsvDataTypeMismatchException(value, fieldType, String.format("Unable to set field value for field '%s' with value '%s' - type is unsupported. Use primitive, boxed primitive, BigDecimal, BigInteger and String types only.", fieldType, value));
                }
                catch (ConversionException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException((Object)value, fieldType);
                    csve.initCause(e);
                    throw csve;
                }
            }
        }
        return o;
    }
}

