/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV2;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2JmxMBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;

public class DegraderLoadBalancerStrategyV2Jmx
implements DegraderLoadBalancerStrategyV2JmxMBean {
    private final DegraderLoadBalancerStrategyV2 _strategy;

    public DegraderLoadBalancerStrategyV2Jmx(DegraderLoadBalancerStrategyV2 strategy) {
        this._strategy = strategy;
    }

    @Override
    public double getOverrideClusterDropRate() {
        double rate = this._strategy.getCurrentOverrideDropRate();
        return rate;
    }

    @Override
    public String toString() {
        return "DegraderLoadBalancerStrategyV2Jmx [_strategy=" + this._strategy + "]";
    }

    @Override
    public int getTotalPointsInHashRing() {
        Map<URI, Integer> uris = this._strategy.getState().getPointsMap();
        int total = 0;
        for (Map.Entry<URI, Integer> entry : uris.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    @Override
    public String getPointsMap() {
        return this._strategy.getState().getPointsMap().toString();
    }

    @Override
    public String getUnhealthyClientsPoints() {
        int pointsPerWeight = this._strategy.getConfig().getPointsPerWeight();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<URI, Integer> entry : this._strategy.getState().getPointsMap().entrySet()) {
            if (entry.getValue() >= pointsPerWeight) continue;
            result.add(entry.getKey().toString() + ":" + entry.getValue() + "/" + pointsPerWeight);
        }
        return ((Object)result).toString();
    }

    @Override
    public String getRingInformation() {
        Ring<URI> ring = this._strategy.getRing();
        if (ring == null) {
            return "Ring for that partition is null";
        }
        return ring.toString();
    }
}

