/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.stores.zk.AbstractZooKeeper;
import com.linkedin.d2.discovery.stores.zk.Retryable;
import com.linkedin.d2.discovery.stores.zk.VanillaZooKeeperAdapter;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryZooKeeper
extends AbstractZooKeeper
implements Retryable {
    private static final Logger _log = LoggerFactory.getLogger(RetryZooKeeper.class);
    private final int _limit;
    private final ScheduledExecutorService _scheduler;
    private final boolean _exponentialBackoff;
    private final long _initInterval;
    private long _interval;
    private final UUID _uuid = UUID.randomUUID();

    public RetryZooKeeper(String connectionString, int sessionTimeout, Watcher watcher, int limit) throws IOException {
        this(connectionString, sessionTimeout, watcher, limit, false, null, 0L);
    }

    public RetryZooKeeper(String connectionString, int sessionTimeout, Watcher watcher, int limit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval) throws IOException {
        super(new VanillaZooKeeperAdapter(connectionString, sessionTimeout, watcher));
        this._limit = limit;
        this._exponentialBackoff = exponentialBackoff;
        this._scheduler = scheduler;
        this._interval = this._initInterval = initInterval;
    }

    public RetryZooKeeper(ZooKeeper zk, int limit) throws IOException {
        this(zk, limit, false, null, 0L);
    }

    public RetryZooKeeper(ZooKeeper zk, int limit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval) throws IOException {
        super(zk);
        this._limit = limit;
        this._exponentialBackoff = exponentialBackoff;
        this._scheduler = scheduler;
        this._interval = this._initInterval = initInterval;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public long getInterval() {
        return this._interval;
    }

    @Override
    public void createUniqueSequential(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback cb, final Object ctx) {
        if (!createMode.isSequential()) {
            this.create(path, data, acl, createMode, cb, ctx);
        }
        final String retryPath = path + "-" + this._uuid.toString() + "-";
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                final String parentPath = path.substring(0, path.lastIndexOf(47));
                final 1 stringCallback = this;
                AsyncCallback.ChildrenCallback childrenCallback = new AsyncCallback.ChildrenCallback(){

                    public void processResult(int ccRC, String ccPath, Object ccCtx, List<String> ccChildren) {
                        KeeperException.Code code = KeeperException.Code.get((int)ccRC);
                        switch (code) {
                            case OK: {
                                ArrayList<String> ourChildren = new ArrayList<String>();
                                for (String child : ccChildren) {
                                    if (!child.contains(RetryZooKeeper.this._uuid.toString())) continue;
                                    ourChildren.add(child);
                                }
                                if (ourChildren.size() > 0) {
                                    ChildrenInspector inspector = new ChildrenInspector(ourChildren.size());
                                    for (String ourChild : ourChildren) {
                                        RetryZooKeeper.this.getData(parentPath + "/" + ourChild, false, (AsyncCallback.DataCallback)inspector, null);
                                    }
                                    break;
                                }
                                _log.info("Retry create operation: path = " + retryPath + "data length: " + RetryZooKeeper.this.getDataLength(data));
                                RetryZooKeeper.this.zkCreate(retryPath, data, acl, createMode, stringCallback, ctx);
                                break;
                            }
                            default: {
                                _log.error("Retry create aborted in getChildren. KeeperException code: " + code);
                            }
                        }
                    }

                    class ChildrenInspector
                    implements AsyncCallback.DataCallback {
                        private int _count;

                        ChildrenInspector(int count) {
                            this._count = count;
                        }

                        public void processResult(int dcRC, String dcPath, Object dcCtx, byte[] dcData, Stat dcStat) {
                            KeeperException.Code code = KeeperException.Code.get((int)dcRC);
                            switch (code) {
                                case OK: {
                                    if (Arrays.equals(data, dcData)) break;
                                    --this._count;
                                    if (this._count != 0) break;
                                    _log.info("Retry create operation: path = " + retryPath + "data length: " + RetryZooKeeper.this.getDataLength(data));
                                    RetryZooKeeper.this.zkCreate(retryPath, data, acl, createMode, stringCallback, ctx);
                                    break;
                                }
                                default: {
                                    _log.error("Retry create stopped in getData. KeeperException code: " + code);
                                }
                            }
                        }
                    }
                };
                RetryZooKeeper.this.getChildren(parentPath, false, childrenCallback, null);
            }

            @Override
            protected void processStringResult(int cbRC, String cbPath, Object cbCtx, String cbName) {
                cb.processResult(cbRC, cbPath, cbCtx, cbName);
            }
        };
        this.zkCreate(retryPath, data, acl, createMode, callback, ctx);
    }

    @Override
    public void create(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                if (!createMode.isSequential()) {
                    _log.info("Retry create operation: path = " + path + " data length " + RetryZooKeeper.this.getDataLength(data));
                    RetryZooKeeper.this.zkCreate(path, data, acl, createMode, this, ctx);
                } else {
                    _log.error("Connection lost during create operation of sequential node. Consider using createUniqueSequential() instead");
                }
            }

            @Override
            protected void processStringResult(int cbRC, String cbPath, Object cbCtx, String cbName) {
                cb.processResult(cbRC, cbPath, cbCtx, cbName);
            }
        };
        this.zkCreate(path, data, acl, createMode, callback, ctx);
    }

    @Override
    public void delete(final String path, final int version, final AsyncCallback.VoidCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry delete operation: path = " + path + " version = " + version);
                RetryZooKeeper.this.zkDelete(path, version, this, ctx);
            }

            @Override
            protected void processVoidResult(int cbRC, String cbPath, Object cbCtx) {
                cb.processResult(cbRC, cbPath, cbCtx);
            }
        };
        this.zkDelete(path, version, callback, ctx);
    }

    @Override
    public void exists(final String path, final Watcher watcher, final AsyncCallback.StatCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry exists operation: path = " + path);
                RetryZooKeeper.this.zkExists(path, watcher, (AsyncCallback.StatCallback)this, ctx);
            }

            @Override
            protected void processStatResult(int cbRC, String cbPath, Object cbCtx, Stat cbStat) {
                cb.processResult(cbRC, cbPath, cbCtx, cbStat);
            }
        };
        this.zkExists(path, watcher, (AsyncCallback.StatCallback)callback, ctx);
    }

    @Override
    public void exists(final String path, final boolean watch, final AsyncCallback.StatCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry exists operation: path = " + path);
                RetryZooKeeper.this.zkExists(path, watch, (AsyncCallback.StatCallback)this, ctx);
            }

            @Override
            protected void processStatResult(int cbRC, String cbPath, Object cbCtx, Stat cbStat) {
                cb.processResult(cbRC, cbPath, cbCtx, cbStat);
            }
        };
        this.zkExists(path, watch, (AsyncCallback.StatCallback)callback, ctx);
    }

    @Override
    public void getChildren(final String path, final Watcher watcher, final AsyncCallback.ChildrenCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry getChildren operation: path = " + path);
                RetryZooKeeper.this.zkGetChildren(path, watcher, (AsyncCallback.ChildrenCallback)this, ctx);
            }

            @Override
            protected void processChildrenResult(int cbRC, String cbPath, Object cbCtx, List<String> cbChildren) {
                cb.processResult(cbRC, cbPath, cbCtx, cbChildren);
            }
        };
        this.zkGetChildren(path, watcher, (AsyncCallback.ChildrenCallback)callback, ctx);
    }

    @Override
    public void getChildren(final String path, final boolean watch, final AsyncCallback.ChildrenCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry getChildren operation: path = " + path);
                RetryZooKeeper.this.zkGetChildren(path, watch, (AsyncCallback.ChildrenCallback)this, ctx);
            }

            @Override
            protected void processChildrenResult(int cbRC, String cbPath, Object cbCtx, List<String> cbChildren) {
                cb.processResult(cbRC, cbPath, cbCtx, cbChildren);
            }
        };
        this.zkGetChildren(path, watch, (AsyncCallback.ChildrenCallback)callback, ctx);
    }

    @Override
    public void getData(final String path, final Watcher watcher, final AsyncCallback.DataCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry getData operation: path = " + path);
                RetryZooKeeper.this.zkGetData(path, watcher, (AsyncCallback.DataCallback)this, ctx);
            }

            @Override
            protected void processDataResult(int cbRC, String cbPath, Object cbCtx, byte[] cbData, Stat cbStat) {
                cb.processResult(cbRC, cbPath, cbCtx, cbData, cbStat);
            }
        };
        this.zkGetData(path, watcher, (AsyncCallback.DataCallback)callback, ctx);
    }

    @Override
    public void getData(final String path, final boolean watch, final AsyncCallback.DataCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry getData operation: path = " + path);
                RetryZooKeeper.this.zkGetData(path, watch, (AsyncCallback.DataCallback)this, ctx);
            }

            @Override
            protected void processDataResult(int cbRC, String cbPath, Object cbCtx, byte[] cbData, Stat cbStat) {
                cb.processResult(cbRC, cbPath, cbCtx, cbData, cbStat);
            }
        };
        this.zkGetData(path, watch, (AsyncCallback.DataCallback)callback, ctx);
    }

    @Override
    public void setData(final String path, final byte[] data, final int version, final AsyncCallback.StatCallback cb, final Object ctx) {
        RetryCallback callback = new RetryCallback(){

            @Override
            protected void retry() {
                _log.info("Retry setData operation: path = " + path + " version = " + version + " data length " + RetryZooKeeper.this.getDataLength(data));
                RetryZooKeeper.this.zkSetData(path, data, version, this, ctx);
            }

            @Override
            protected void processStatResult(int cbRC, String cbPath, Object cbCtx, Stat cbStat) {
                cb.processResult(cbRC, cbPath, cbCtx, cbStat);
            }
        };
        this.zkSetData(path, data, version, callback, ctx);
    }

    private int getDataLength(byte[] data) {
        return data == null ? 0 : data.length;
    }

    public void zkCreate(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this._zk.create(path, data, acl, createMode, cb, ctx);
    }

    public void zkDelete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this._zk.delete(path, version, cb, ctx);
    }

    public void zkExists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this._zk.exists(path, watch, cb, ctx);
    }

    public void zkExists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this._zk.exists(path, watcher, cb, ctx);
    }

    public void zkGetChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this._zk.getChildren(path, watch, cb, ctx);
    }

    public void zkGetChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this._zk.getChildren(path, watcher, cb, ctx);
    }

    public void zkGetData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this._zk.getData(path, watch, cb, ctx);
    }

    public void zkGetData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this._zk.getData(path, watcher, cb, ctx);
    }

    public void zkSetData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this._zk.setData(path, data, version, cb, ctx);
    }

    private abstract class RetryCallback
    implements AsyncCallback.DataCallback,
    AsyncCallback.ChildrenCallback,
    AsyncCallback.StatCallback,
    AsyncCallback.StringCallback,
    AsyncCallback.VoidCallback {
        private int _retry = 0;

        private RetryCallback() {
        }

        protected abstract void retry();

        protected void processDataResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            throw new UnsupportedOperationException("Must override use processDataResult");
        }

        protected void processChildrenResult(int rc, String path, Object ctx, List<String> children) {
            throw new UnsupportedOperationException("Must override use processChildResult");
        }

        protected void processStatResult(int rc, String path, Object ctx, Stat stat) {
            throw new UnsupportedOperationException("Must override use processStatResult");
        }

        protected void processStringResult(int rc, String path, Object ctx, String name) {
            throw new UnsupportedOperationException("Must override use processStringResult");
        }

        protected void processVoidResult(int rc, String path, Object ctx) {
            throw new UnsupportedOperationException("Must override use processVoidResult");
        }

        private void retryLimitedTimes() {
            ++this._retry;
            if (this._retry > RetryZooKeeper.this._limit) {
                RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                _log.error("Connection lost. Give up after " + RetryZooKeeper.this._limit + " retries.");
                return;
            }
            if (!RetryZooKeeper.this._exponentialBackoff) {
                this.retry();
            } else {
                Runnable retryHandler = new Runnable(){

                    @Override
                    public void run() {
                        RetryZooKeeper.this._interval = RetryZooKeeper.this._interval * 2L;
                        RetryCallback.this.retry();
                    }
                };
                RetryZooKeeper.this._scheduler.schedule(retryHandler, RetryZooKeeper.this._interval, TimeUnit.MILLISECONDS);
            }
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            if (result != KeeperException.Code.CONNECTIONLOSS) {
                RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                this.processDataResult(rc, path, ctx, data, stat);
            } else {
                this.retryLimitedTimes();
            }
        }

        public void processResult(int rc, String path, Object ctx, List<String> children) {
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            if (result != KeeperException.Code.CONNECTIONLOSS) {
                RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                this.processChildrenResult(rc, path, ctx, children);
            } else {
                this.retryLimitedTimes();
            }
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            if (result != KeeperException.Code.CONNECTIONLOSS) {
                RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                this.processStatResult(rc, path, ctx, stat);
            } else {
                this.retryLimitedTimes();
            }
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            switch (result) {
                case CONNECTIONLOSS: {
                    this.retryLimitedTimes();
                    break;
                }
                default: {
                    RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                    this.processStringResult(rc, path, ctx, name);
                }
            }
        }

        public void processResult(int rc, String path, Object ctx) {
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            switch (result) {
                case CONNECTIONLOSS: {
                    this.retryLimitedTimes();
                    break;
                }
                default: {
                    RetryZooKeeper.this._interval = RetryZooKeeper.this._initInterval;
                    this.processVoidResult(rc, path, ctx);
                }
            }
        }
    }
}

