/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreAsync;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractPropertyStoreAsync<T>
implements PropertyStoreAsync<T>,
PropertyStore<T> {
    @Override
    public final void put(String name, T value) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this.put(name, value, (Callback<None>)callback);
        AbstractPropertyStoreAsync.getUninterruptibly(callback);
    }

    @Override
    public final void remove(String name) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this.remove(name, (Callback<None>)callback);
        AbstractPropertyStoreAsync.getUninterruptibly(callback);
    }

    @Override
    public final T get(String name) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this.get(name, callback);
        return (T)AbstractPropertyStoreAsync.getUninterruptibly(callback);
    }

    @Override
    public final void shutdown(final PropertyEventThread.PropertyEventShutdownCallback callback) {
        Callback<None> cb = new Callback<None>(){

            public void onSuccess(None none) {
                callback.done();
            }

            public void onError(Throwable e) {
                callback.done();
            }
        };
        this.shutdown(cb);
    }

    /*
     * Loose catch block
     */
    protected static <U> U getUninterruptibly(Future<U> future) throws PropertyStoreException {
        boolean interrupted = false;
        while (true) {
            try {
                U result = future.get();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return result;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new PropertyStoreException(e);
        }
    }
}

