/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.hashing.Ring;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StaticRingProvider
implements HashRingProvider {
    private final List<Ring<URI>> _rings;

    public StaticRingProvider(Ring<URI> ring) {
        ArrayList<Ring<URI>> rings = new ArrayList<Ring<URI>>();
        rings.add(ring);
        this._rings = Collections.unmodifiableList(rings);
    }

    public StaticRingProvider(List<Ring<URI>> rings) {
        this._rings = Collections.unmodifiableList(new ArrayList<Ring<URI>>(rings));
    }

    @Override
    public <K> MapKeyResult<Ring<URI>, K> getRings(URI serviceUri, Iterable<K> keys) throws ServiceUnavailableException {
        if (this._rings.size() < 1) {
            throw new ServiceUnavailableException("Ring not configured:", serviceUri.toString());
        }
        HashMap<Ring<URI>, HashSet<K>> result = new HashMap<Ring<URI>, HashSet<K>>();
        ArrayList unmappedKeys = new ArrayList();
        for (K key : keys) {
            try {
                long longK = Long.parseLong(key.toString());
                int index = (int)longK % this._rings.size();
                Ring<URI> ring = this._rings.get(index);
                HashSet<K> set = (HashSet<K>)result.get(ring);
                if (set == null) {
                    set = new HashSet<K>();
                    result.put(ring, set);
                }
                set.add(key);
            }
            catch (NumberFormatException e) {
                unmappedKeys.add(new MapKeyResult.UnmappedKey<K>(key, MapKeyResult.ErrorType.FAIL_TO_FIND_PARTITION));
            }
        }
        return new MapKeyResult(result, unmappedKeys);
    }

    @Override
    public Map<Integer, Ring<URI>> getRings(URI serviceUri) {
        int partitionCount = this._rings.size();
        HashMap<Integer, Ring<URI>> ringMap = new HashMap<Integer, Ring<URI>>(partitionCount * 2);
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            ringMap.put(partitionId, this._rings.get(partitionId));
        }
        return ringMap;
    }
}

