/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.util.hashing.HashFunction;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Hash
implements HashFunction<String[]> {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final byte[] ONE_NULL = new byte[]{0};

    @Override
    public int hash(String[] keyTokens) {
        byte[] digest = this.getMD5Digest(keyTokens);
        return (0xFF & digest[12]) << 24 | (0xFF & digest[13]) << 16 | (0xFF & digest[14]) << 8 | 0xFF & digest[15];
    }

    @Override
    public long hashLong(String[] keyTokens) {
        byte[] digest = this.getMD5Digest(keyTokens);
        return (0xFFL & (long)digest[8]) << 56 | (0xFFL & (long)digest[9]) << 48 | (0xFFL & (long)digest[10]) << 40 | (0xFFL & (long)digest[11]) << 32 | (0xFFL & (long)digest[12]) << 24 | (0xFFL & (long)digest[13]) << 16 | (0xFFL & (long)digest[14]) << 8 | 0xFFL & (long)digest[15];
    }

    private byte[] getMD5Digest(String[] keyTokens) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (int i = 0; i < keyTokens.length; ++i) {
                md.update(keyTokens[i].getBytes(UTF8));
                md.update(ONE_NULL);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

