/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.util.HostToKeyMapper;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.hashing.MD5Hash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.partitions.PartitionInfoProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashKeyMapper
implements KeyMapper {
    private final HashFunction<String[]> _hashFunction;
    private final HashRingProvider _ringProvider;
    private final PartitionInfoProvider _partitionInfoProvider;
    private final Random _random;
    private final Logger _log = LoggerFactory.getLogger(ConsistentHashKeyMapper.class);

    public ConsistentHashKeyMapper(HashRingProvider ringProvider, PartitionInfoProvider partitionInfoProvider) {
        this._hashFunction = new MD5Hash();
        if (ringProvider == null) {
            throw new IllegalArgumentException("ringProvider must not be null");
        }
        if (partitionInfoProvider == null) {
            throw new UnsupportedOperationException("partitionInfoProvider must not be null");
        }
        this._ringProvider = ringProvider;
        this._partitionInfoProvider = partitionInfoProvider;
        this._random = new Random();
    }

    public ConsistentHashKeyMapper(HashRingProvider ringProvider) {
        this(ringProvider, null);
    }

    @Override
    public <K> HostToKeyMapper<K> mapKeysV3(URI serviceUri, Collection<K> keys, int limitNumHostsPerPartition) throws ServiceUnavailableException {
        return this.getHostToKeyMapper(serviceUri, keys, limitNumHostsPerPartition, null);
    }

    @Override
    public <K, S> HostToKeyMapper<K> mapKeysV3(URI serviceUri, Collection<K> keys, int limitNumHostsPerPartition, S stickyKey) throws ServiceUnavailableException {
        return this.getHostToKeyMapper(serviceUri, keys, limitNumHostsPerPartition, stickyKey);
    }

    @Override
    public HostToKeyMapper<Integer> getAllPartitionsMultipleHosts(URI serviceUri, int numHostPerPartition) throws ServiceUnavailableException {
        return this.getHostToKeyMapper(serviceUri, null, numHostPerPartition, null);
    }

    @Override
    public <S> HostToKeyMapper<Integer> getAllPartitionsMultipleHosts(URI serviceUri, int limitHostPerPartition, S stickyKey) throws ServiceUnavailableException {
        return this.getHostToKeyMapper(serviceUri, null, limitHostPerPartition, stickyKey);
    }

    public <K, S> HostToKeyMapper<K> getHostToKeyMapper(URI serviceUri, Collection<K> keys, int limitHostPerPartition, S stickyKey) throws ServiceUnavailableException {
        int hash = stickyKey == null ? this._random.nextInt() : stickyKey.hashCode();
        return this._partitionInfoProvider.getPartitionInformation(serviceUri, keys, limitHostPerPartition, hash);
    }

    @Override
    public <K> MapKeyResult<URI, K> mapKeysV2(URI serviceUri, Iterable<K> keys) throws ServiceUnavailableException {
        MapKeyResult<Ring<URI>, K> keyToPartitionResult = this._ringProvider.getRings(serviceUri, keys);
        Map<Ring<URI>, Collection<K>> ringToKeys = keyToPartitionResult.getMapResult();
        HashMap<URI, ArrayList<K>> result = new HashMap<URI, ArrayList<K>>();
        ArrayList unmappedKeys = new ArrayList();
        unmappedKeys.addAll(keyToPartitionResult.getUnmappedKeys());
        for (Map.Entry<Ring<URI>, Collection<K>> entry : ringToKeys.entrySet()) {
            MapKeyResult<URI, K> keyToHostResult = this.doMapKeys(entry.getKey(), (Iterable)entry.getValue());
            Map<URI, Collection<K>> hostToKeys = keyToHostResult.getMapResult();
            for (Map.Entry<URI, Collection<K>> hostEntry : hostToKeys.entrySet()) {
                URI uri = hostEntry.getKey();
                ArrayList<K> collection = (ArrayList<K>)result.get(uri);
                if (collection == null) {
                    collection = new ArrayList<K>();
                    result.put(uri, collection);
                }
                collection.addAll(hostEntry.getValue());
            }
            unmappedKeys.addAll(keyToHostResult.getUnmappedKeys());
        }
        return new MapKeyResult(result, unmappedKeys);
    }

    private <K> MapKeyResult<URI, K> doMapKeys(Ring<URI> ring, Iterable<K> keys) throws ServiceUnavailableException {
        String[] keyTokens = new String[1];
        ArrayList unmappedKeys = new ArrayList();
        HashMap<URI, ArrayList<K>> result = new HashMap<URI, ArrayList<K>>();
        for (K key : keys) {
            keyTokens[0] = key.toString();
            int hashCode = this._hashFunction.hash(keyTokens);
            URI uri = ring.get(hashCode);
            if (uri == null) {
                unmappedKeys.add(new MapKeyResult.UnmappedKey<K>(key, MapKeyResult.ErrorType.NO_HOST_AVAILABLE_IN_PARTITION));
                continue;
            }
            ArrayList<K> collection = (ArrayList<K>)result.get(uri);
            if (collection == null) {
                collection = new ArrayList<K>();
                result.put(uri, collection);
            }
            collection.add(key);
        }
        return new MapKeyResult(result, unmappedKeys);
    }
}

