/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.clients.DynamicClient;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.RequestContext;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LoadBalancerUtil {
    private static final Pattern DOT_PATTERN = Pattern.compile(Pattern.quote("."));

    public static Throwable findOriginalThrowable(Throwable throwable) {
        Throwable original = throwable;
        for (int depth = 0; original.getCause() != null && depth < 100; ++depth) {
            original = original.getCause();
        }
        return original;
    }

    public static String join(Collection<?> toJoin, String joinBy) {
        if (toJoin == null) {
            return null;
        }
        String joined = "";
        for (Object o : toJoin) {
            joined = joined + o.toString() + joinBy;
        }
        if (joined.length() > 0) {
            joined = joined.substring(0, joined.length() - joinBy.length());
        }
        return joined;
    }

    public static String getServiceNameFromUri(URI uri) {
        return uri.getAuthority();
    }

    public static String getPathFromUri(URI uri) {
        return uri.getPath();
    }

    public static String getRawPathFromUri(URI uri) {
        return uri.getRawPath();
    }

    public static Map<String, Map<String, String>> getSubProperties(String prefix, String propertiesString) throws IOException {
        Properties fileProperties = new Properties();
        HashMap<String, Map<String, String>> utilServicePropertyMap = new HashMap<String, Map<String, String>>();
        fileProperties.load(new StringReader(propertiesString));
        for (Map.Entry<Object, Object> row : fileProperties.entrySet()) {
            String key = row.getKey().toString();
            String property = row.getValue().toString();
            if (!key.startsWith(prefix)) continue;
            String[] keySplit = DOT_PATTERN.split(key, 3);
            String serviceName = keySplit[1];
            String subKey = keySplit[2];
            HashMap<String, String> serviceProperties = (HashMap<String, String>)utilServicePropertyMap.get(serviceName);
            if (serviceProperties == null) {
                serviceProperties = new HashMap<String, String>();
                utilServicePropertyMap.put(serviceName, serviceProperties);
            }
            serviceProperties.put(subKey, property);
        }
        return utilServicePropertyMap;
    }

    public static <C> C getOrElse(Map<String, C> map, String key, C elseReturn) {
        C obj = map.get(key);
        if (obj == null) {
            return elseReturn;
        }
        return obj;
    }

    public static <C> List<C> getOrElse(List<C> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static File createTempDirectory(String name) throws IOException {
        File temp = File.createTempFile("temp-" + name, Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static void syncShutdownClient(DynamicClient client, Logger log) {
        LogUtil.info(log, "shutting down");
        final CountDownLatch latch = new CountDownLatch(1);
        client.shutdown(new Callback<None>(){

            public void onSuccess(None t) {
                latch.countDown();
            }

            public void onError(Throwable e) {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                LogUtil.warn(log, "unable to shutdown properly after 5 seconds");
            } else {
                LogUtil.info(log, "shutdown complete");
            }
        }
        catch (InterruptedException e) {
            LogUtil.warn(log, "shutdown was interrupted");
        }
    }

    public static class TargetHints {
        public static final String TARGET_SERVICE_KEY_NAME = "D2-Hint-TargetService";

        public static void setRequestContextTargetService(RequestContext context, URI targetService) {
            context.putLocalAttr(TARGET_SERVICE_KEY_NAME, (Object)targetService);
        }

        public static URI getRequestContextTargetService(RequestContext context) {
            return (URI)context.getLocalAttr(TARGET_SERVICE_KEY_NAME);
        }
    }
}

