/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.RingFactory;
import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.Ring;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointBasedConsistentHashRingFactory<T>
implements RingFactory<T> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger _log = LoggerFactory.getLogger(PointBasedConsistentHashRingFactory.class);
    private final Map<T, List<ConsistentHashRing.Point<T>>> _ringPoints = new HashMap<T, List<ConsistentHashRing.Point<T>>>();
    private final MessageDigest _md;
    private final DegraderLoadBalancerStrategyConfig _config;
    private final int POINTS_CLEANUP_MIN_UNUSED_ENTRY = 3;
    private final int HASH_PARTITION_NUM = 4;
    private final int POINT_SIZE_IN_BYTE = 4;

    public PointBasedConsistentHashRingFactory(DegraderLoadBalancerStrategyConfig config) {
        this._config = config;
        try {
            this._md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            _log.error("unable to get md5 hash function");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> points) {
        ArrayList newRingPoints = new ArrayList();
        this.clearPoints(points.size());
        for (Map.Entry<T, Integer> entry : points.entrySet()) {
            T t = entry.getKey();
            int numDesiredPoints = entry.getValue();
            List<ConsistentHashRing.Point<T>> tPoints = this.getPointList(t, numDesiredPoints);
            newRingPoints.addAll(tPoints.subList(0, numDesiredPoints));
        }
        _log.debug("Creating new hash ring with the following points {}", newRingPoints);
        return new ConsistentHashRing(newRingPoints);
    }

    public Map<T, List<ConsistentHashRing.Point<T>>> getPointsMap() {
        return this._ringPoints;
    }

    private void clearPoints(int size) {
        int unusedEntryThreshold;
        int unusedEntries = this._ringPoints.size() - size;
        if (unusedEntries > Math.max(unusedEntryThreshold = (int)((double)this._ringPoints.size() * this._config.getHashRingPointCleanUpRate()), 3)) {
            this._ringPoints.clear();
        }
    }

    private List<ConsistentHashRing.Point<T>> getPointList(T t, int numDesiredPoints) {
        int i;
        byte[] hashBytes;
        List<ConsistentHashRing.Point<T>> pointList = this._ringPoints.get(t);
        numDesiredPoints = (numDesiredPoints + 4 - 1) / 4 * 4;
        if (pointList == null) {
            pointList = new ArrayList<ConsistentHashRing.Point<T>>(numDesiredPoints);
            this._ringPoints.put(t, pointList);
        } else if (numDesiredPoints <= pointList.size()) {
            return pointList;
        }
        if (pointList.size() < 4) {
            hashBytes = t.toString().getBytes(UTF8);
        } else {
            ByteBuffer hashKey = ByteBuffer.allocate(16);
            hashKey.order(ByteOrder.LITTLE_ENDIAN);
            for (i = pointList.size() - 4; i < pointList.size(); ++i) {
                hashKey.putInt(pointList.get(i).getHash());
            }
            hashBytes = hashKey.array();
        }
        Buffer buf = null;
        for (i = pointList.size(); i < numDesiredPoints; ++i) {
            if (buf == null || buf.remaining() < 4) {
                hashBytes = this._md.digest(hashBytes);
                buf = ByteBuffer.wrap(hashBytes);
                ((ByteBuffer)buf).order(ByteOrder.LITTLE_ENDIAN);
            }
            int hashInt = ((ByteBuffer)buf).getInt();
            pointList.add(new ConsistentHashRing.Point<T>(t, hashInt));
        }
        return pointList;
    }
}

