/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.TrackerClientUpdater;
import com.linkedin.d2.balancer.util.RateLimitedLogger;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckClientBuilder;
import com.linkedin.util.clock.Clock;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerQuarantine {
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerQuarantine.class);
    private static final long ERROR_REPORT_PERIOD = 60000L;
    private volatile QuarantineStates _quarantineState;
    private final TrackerClient _trackerClient;
    private final HealthCheck _healthCheckClient;
    private final String _serviceName;
    private final ScheduledExecutorService _executorService;
    private final Clock _clock;
    private final long _timeBetweenHC;
    private volatile boolean _isShutdown;
    private long _lastChecked;
    private long _timeTilNextCheck;
    private final DegraderLoadBalancerStrategyConfig _config;
    private final RateLimitedLogger _rateLimitedLogger;

    DegraderLoadBalancerQuarantine(TrackerClientUpdater client, DegraderLoadBalancerStrategyConfig config, String serviceName) {
        this._trackerClient = client.getTrackerClient();
        this._config = config;
        this._executorService = config.getExecutorService();
        this._clock = config.getClock();
        this._timeBetweenHC = 1000L;
        this._serviceName = serviceName;
        this._quarantineState = QuarantineStates.FAILURE;
        this._timeTilNextCheck = config.getUpdateIntervalMs();
        this._lastChecked = Integer.MIN_VALUE;
        this._isShutdown = false;
        this._rateLimitedLogger = new RateLimitedLogger(_log, 60000L, config.getClock());
        if (this._timeBetweenHC < this._config.getQuarantineLatency()) {
            _log.error("Illegal quarantine configurations for service {}: Interval {} too short", (Object)this._serviceName, (Object)this._timeBetweenHC);
            throw new IllegalArgumentException("Quarantine interval too short");
        }
        HealthCheck healthCheckClient = null;
        try {
            healthCheckClient = new HealthCheckClientBuilder().setHealthCheckOperations(config.getHealthCheckOperations()).setHealthCheckPath(config.getHealthCheckPath()).setServicePath(config.getServicePath()).setClock(config.getClock()).setLatency(config.getQuarantineLatency()).setMethod(config.getHealthCheckMethod()).setClient(this._trackerClient).build();
        }
        catch (URISyntaxException e) {
            _log.error("Error to generate healthCheckClient", (Throwable)e);
        }
        this._healthCheckClient = healthCheckClient;
    }

    private void healthCheckNTimes(final int n) {
        if (n <= 0 || this._isShutdown) {
            return;
        }
        final long startTime = this._clock.currentTimeMillis();
        Callback<None> healthCheckCallback = new Callback<None>(){

            public void onError(Throwable e) {
                DegraderLoadBalancerQuarantine.this._rateLimitedLogger.warn("Healthchecking failed for {} (service={}): {}", new Object[]{DegraderLoadBalancerQuarantine.this._trackerClient.getUri(), DegraderLoadBalancerQuarantine.this._serviceName, e});
                DegraderLoadBalancerQuarantine.this._quarantineState = QuarantineStates.FAILURE;
            }

            public void onSuccess(None result) {
                if (n > 1) {
                    if (!DegraderLoadBalancerQuarantine.this._isShutdown) {
                        long nextCheckDelay = DegraderLoadBalancerQuarantine.this._timeBetweenHC - (DegraderLoadBalancerQuarantine.this._clock.currentTimeMillis() - startTime);
                        if (nextCheckDelay > 0L) {
                            DegraderLoadBalancerQuarantine.this._executorService.schedule(() -> DegraderLoadBalancerQuarantine.this.healthCheckNTimes(n - 1), nextCheckDelay, TimeUnit.MILLISECONDS);
                        } else {
                            _log.error("Delay exceeded the defined checking interval");
                        }
                    }
                } else {
                    DegraderLoadBalancerQuarantine.this._quarantineState = QuarantineStates.SUCCESS;
                }
            }
        };
        this._healthCheckClient.checkHealth(healthCheckCallback);
    }

    boolean checkUpdateQuarantineState() {
        long currentTime;
        this._lastChecked = currentTime = this._config.getClock().currentTimeMillis();
        int repeatNum = 5;
        switch (this._quarantineState) {
            case DISABLED: {
                throw new IllegalStateException("State update for disabled quarantine");
            }
            case FAILURE: {
                if (this._isShutdown) {
                    _log.error("Could not check quarantine state since the executor is shutdown");
                    break;
                }
                this._executorService.schedule(() -> this.healthCheckNTimes(repeatNum), this._timeTilNextCheck, TimeUnit.MILLISECONDS);
                this._timeTilNextCheck *= 2L;
                this._quarantineState = QuarantineStates.WAIT;
                break;
            }
            case WAIT: {
                if (this._timeTilNextCheck <= 60000L) break;
                this._rateLimitedLogger.error("Client {}  for service {} is being kept in quarantine for {} seconds, Please check to make sure it is healthy", new Object[]{this._trackerClient.getUri(), this._serviceName, 1.0 * (double)this._timeTilNextCheck / 1000.0});
                break;
            }
            case SUCCESS: {
                this._quarantineState = QuarantineStates.DISABLED;
                _log.info("checkUpdateQuarantineState: quarantine state for client {} service {} is DISABLED", (Object)this._trackerClient.getUri(), (Object)this._serviceName);
                return true;
            }
        }
        return false;
    }

    public void shutdown() {
        if (this._isShutdown) {
            _log.error("Quarantine already shutdown");
            return;
        }
        this._isShutdown = true;
    }

    public void reset(boolean resetInterval) {
        this._quarantineState = QuarantineStates.FAILURE;
        if (resetInterval) {
            this._timeTilNextCheck = this._config.getUpdateIntervalMs();
        } else {
            _log.warn("HealthCheck: Interval {}ms for client {}", (Object)this._timeTilNextCheck, (Object)this._trackerClient.getUri());
        }
    }

    long getLastChecked() {
        return this._lastChecked;
    }

    HealthCheck getHealthCheckClient() {
        return this._healthCheckClient;
    }

    public String toString() {
        return "TrackerClientQuarantine [_client=" + this._trackerClient.getUri() + ", _quarantineState=" + (Object)((Object)this._quarantineState) + ", _timeTilNextCheck=" + this._timeTilNextCheck / 1000L + "s]";
    }

    private static enum QuarantineStates {
        FAILURE,
        WAIT,
        SUCCESS,
        DISABLED;

    }
}

