/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterProperties {
    private final String _clusterName;
    private final Map<String, String> _properties;
    private final PartitionProperties _partitionProperties;
    @Deprecated
    private final Set<URI> _banned;
    @Deprecated
    private final List<String> _prioritizedSchemes;

    public ClusterProperties(String clusterName) {
        this(clusterName, Collections.emptyList());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes) {
        this(clusterName, prioritizedSchemes, Collections.emptyMap());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties) {
        this(clusterName, prioritizedSchemes, properties, new HashSet<URI>());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> banned) {
        this(clusterName, prioritizedSchemes, properties, banned, NullPartitionProperties.getInstance());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> banned, PartitionProperties partitionProperties) {
        this._clusterName = clusterName;
        this._prioritizedSchemes = prioritizedSchemes != null ? Collections.unmodifiableList(prioritizedSchemes) : Collections.emptyList();
        this._properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
        this._banned = Collections.unmodifiableSet(banned);
        this._partitionProperties = partitionProperties;
    }

    public boolean isBanned(URI uri) {
        return this._banned.contains(uri);
    }

    public Set<URI> getBanned() {
        return this._banned;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public List<String> getPrioritizedSchemes() {
        return this._prioritizedSchemes;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public PartitionProperties getPartitionProperties() {
        return this._partitionProperties;
    }

    public String toString() {
        return "ClusterProperties [_clusterName=" + this._clusterName + ", _prioritizedSchemes=" + this._prioritizedSchemes + ", _properties=" + this._properties + ", _banned=" + this._banned + ", _partitionProperties=" + this._partitionProperties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._banned == null ? 0 : this._banned.hashCode());
        result = 31 * result + (this._clusterName == null ? 0 : this._clusterName.hashCode());
        result = 31 * result + (this._prioritizedSchemes == null ? 0 : this._prioritizedSchemes.hashCode());
        result = 31 * result + (this._properties == null ? 0 : this._properties.hashCode());
        result = 31 * result + (this._partitionProperties == null ? 0 : this._partitionProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterProperties other = (ClusterProperties)obj;
        if (this._banned == null ? other._banned != null : !this._banned.equals(other._banned)) {
            return false;
        }
        if (this._clusterName == null ? other._clusterName != null : !this._clusterName.equals(other._clusterName)) {
            return false;
        }
        if (this._prioritizedSchemes == null ? other._prioritizedSchemes != null : !this._prioritizedSchemes.equals(other._prioritizedSchemes)) {
            return false;
        }
        if (this._properties == null ? other._properties != null : !this._properties.equals(other._properties)) {
            return false;
        }
        return !(this._partitionProperties == null ? other._partitionProperties != null : !this._partitionProperties.equals(other._partitionProperties));
    }
}

