/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.D2ClusterPartitionConfiguration;
import com.linkedin.d2.PartitionTypeEnum;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.hashAlgorithm;
import com.linkedin.d2.rangedPartitionProperties;

public class PartitionPropertiesConverter {
    public static PartitionProperties toProperties(D2ClusterPartitionConfiguration config) {
        PartitionProperties partitionProperties;
        switch (config.getType()) {
            case RANGE: {
                rangedPartitionProperties rangedPartitionProperties2 = config.getPartitionTypeSpecificData().getRangedPartitionProperties();
                partitionProperties = new RangeBasedPartitionProperties(config.getPartitionKeyRegex(), rangedPartitionProperties2.getKeyRangeStart(), rangedPartitionProperties2.getPartitionSize(), config.getPartitionCount());
                break;
            }
            case HASH: {
                HashBasedPartitionProperties.HashAlgorithm algorithm;
                switch (config.getPartitionTypeSpecificData().getHashAlgorithm()) {
                    case MODULO: {
                        algorithm = HashBasedPartitionProperties.HashAlgorithm.MODULO;
                        break;
                    }
                    case MD5: {
                        algorithm = HashBasedPartitionProperties.HashAlgorithm.MD5;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported hash algorithm: " + config.getPartitionTypeSpecificData().getHashAlgorithm());
                    }
                }
                partitionProperties = new HashBasedPartitionProperties(config.getPartitionKeyRegex(), config.getPartitionCount(), algorithm);
                break;
            }
            case NONE: {
                partitionProperties = NullPartitionProperties.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported partitionType: " + config.getType());
            }
        }
        return partitionProperties;
    }

    public static D2ClusterPartitionConfiguration toConfig(PartitionProperties property) {
        D2ClusterPartitionConfiguration config;
        switch (property.getPartitionType()) {
            case RANGE: {
                RangeBasedPartitionProperties range = (RangeBasedPartitionProperties)property;
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.RANGE);
                config.setPartitionKeyRegex(range.getPartitionKeyRegex());
                config.setPartitionCount(range.getPartitionCount());
                D2ClusterPartitionConfiguration.PartitionTypeSpecificData specificData = new D2ClusterPartitionConfiguration.PartitionTypeSpecificData();
                rangedPartitionProperties rangedPartitionProperties2 = new rangedPartitionProperties();
                rangedPartitionProperties2.setKeyRangeStart(range.getKeyRangeStart());
                rangedPartitionProperties2.setPartitionSize(range.getPartitionSize());
                specificData.setRangedPartitionProperties(rangedPartitionProperties2);
                config.setPartitionTypeSpecificData(specificData);
                break;
            }
            case HASH: {
                HashBasedPartitionProperties hash = (HashBasedPartitionProperties)property;
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.HASH);
                config.setPartitionKeyRegex(hash.getPartitionKeyRegex());
                config.setPartitionCount(hash.getPartitionCount());
                D2ClusterPartitionConfiguration.PartitionTypeSpecificData specificData = new D2ClusterPartitionConfiguration.PartitionTypeSpecificData();
                specificData.setHashAlgorithm(hashAlgorithm.valueOf((String)hash.getHashAlgorithm().name()));
                config.setPartitionTypeSpecificData(specificData);
                break;
            }
            case NONE: {
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.NONE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported partitionType: " + (Object)((Object)property.getPartitionType()));
            }
        }
        return config;
    }
}

