/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyClient
implements TransportClient {
    private static final Logger _log = LoggerFactory.getLogger(TransportClient.class);
    private final TransportClientFactory _clientFactory;
    private final Map<String, String> _properties;
    private volatile TransportClient _wrappedClient;

    public LazyClient(Map<String, String> properties, TransportClientFactory clientFactory) {
        this._properties = properties;
        this._clientFactory = clientFactory;
        LogUtil.debug(_log, "created lazy client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        this.getWrappedClient().restRequest(request, requestContext, wireAttrs, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        this.getWrappedClient().streamRequest(request, requestContext, wireAttrs, callback);
    }

    public void shutdown(Callback<None> callback) {
        this.getWrappedClient().shutdown(callback);
    }

    public synchronized TransportClient getWrappedClient() {
        if (this._wrappedClient == null) {
            LogUtil.debug(_log, "initializing wrapped client with properties: ", this._properties);
            this._wrappedClient = this._clientFactory.getClient(this._properties);
        }
        return this._wrappedClient;
    }

    public String toString() {
        return "LazyClient [_clientFactory=" + this._clientFactory + ", _properties=" + this._properties + ", _wrappedClient=" + this._wrappedClient + "]";
    }
}

