/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.trigger.ConditionChecker;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;

public class BasicTimeChecker
implements ConditionChecker {
    public static final String type = "BasicTimeChecker";
    private long firstCheckTime;
    private long nextCheckTime;
    private DateTimeZone timezone;
    private boolean isRecurring = true;
    private boolean skipPastChecks = true;
    private ReadablePeriod period;
    private final String id;

    public BasicTimeChecker(String id, long firstCheckTime, DateTimeZone timezone, boolean isRecurring, boolean skipPastChecks, ReadablePeriod period) {
        this.id = id;
        this.firstCheckTime = firstCheckTime;
        this.timezone = timezone;
        this.isRecurring = isRecurring;
        this.skipPastChecks = skipPastChecks;
        this.period = period;
        this.nextCheckTime = firstCheckTime;
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    public long getFirstCheckTime() {
        return this.firstCheckTime;
    }

    public DateTimeZone getTimeZone() {
        return this.timezone;
    }

    public boolean isRecurring() {
        return this.isRecurring;
    }

    public boolean isSkipPastChecks() {
        return this.skipPastChecks;
    }

    public ReadablePeriod getPeriod() {
        return this.period;
    }

    @Override
    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public BasicTimeChecker(String id, long firstCheckTime, DateTimeZone timezone, long nextCheckTime, boolean isRecurring, boolean skipPastChecks, ReadablePeriod period) {
        this.id = id;
        this.firstCheckTime = firstCheckTime;
        this.timezone = timezone;
        this.nextCheckTime = nextCheckTime;
        this.isRecurring = isRecurring;
        this.skipPastChecks = skipPastChecks;
        this.period = period;
    }

    @Override
    public Boolean eval() {
        return this.nextCheckTime < System.currentTimeMillis();
    }

    @Override
    public void reset() {
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return type;
    }

    public static BasicTimeChecker createFromJson(Object obj) throws Exception {
        return BasicTimeChecker.createFromJson((HashMap)obj);
    }

    public static BasicTimeChecker createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create checker of BasicTimeChecker from " + jsonObj.get("type"));
        }
        Long firstCheckTime = Long.valueOf((String)jsonObj.get("firstCheckTime"));
        String timezoneId = (String)jsonObj.get("timezone");
        long nextCheckTime = Long.valueOf((String)jsonObj.get("nextCheckTime"));
        DateTimeZone timezone = DateTimeZone.forID((String)timezoneId);
        boolean isRecurring = Boolean.valueOf((String)jsonObj.get("isRecurring"));
        boolean skipPastChecks = Boolean.valueOf((String)jsonObj.get("skipPastChecks"));
        ReadablePeriod period = Utils.parsePeriodString((String)jsonObj.get("period"));
        String id = (String)jsonObj.get("id");
        BasicTimeChecker checker = new BasicTimeChecker(id, firstCheckTime, timezone, nextCheckTime, isRecurring, skipPastChecks, period);
        if (skipPastChecks) {
            checker.updateNextCheckTime();
        }
        return checker;
    }

    @Override
    public BasicTimeChecker fromJson(Object obj) throws Exception {
        return BasicTimeChecker.createFromJson(obj);
    }

    private void updateNextCheckTime() {
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    private long calculateNextCheckTime() {
        DateTime date = new DateTime(this.nextCheckTime).withZone(this.timezone);
        int count = 0;
        while (!date.isAfterNow()) {
            if (count > 100000) {
                throw new IllegalStateException("100000 increments of period did not get to present time.");
            }
            if (this.period == null) break;
            date = date.plus(this.period);
            ++count;
            if (this.skipPastChecks) continue;
        }
        return date.getMillis();
    }

    @Override
    public Object getNum() {
        return null;
    }

    @Override
    public Object toJson() {
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        jsonObj.put("type", type);
        jsonObj.put("firstCheckTime", String.valueOf(this.firstCheckTime));
        jsonObj.put("timezone", this.timezone.getID());
        jsonObj.put("nextCheckTime", String.valueOf(this.nextCheckTime));
        jsonObj.put("isRecurring", String.valueOf(this.isRecurring));
        jsonObj.put("skipPastChecks", String.valueOf(this.skipPastChecks));
        jsonObj.put("period", Utils.createPeriodString(this.period));
        jsonObj.put("id", this.id);
        return jsonObj;
    }

    @Override
    public void stopChecker() {
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }
}

