/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public abstract class AbstractJdbcLoader {
    private AzkabanDataSource dataSource;

    public AbstractJdbcLoader(Props props) {
        this.dataSource = DataSourceUtils.getDataSource(props);
    }

    protected Connection getDBConnection(boolean autoCommit) throws IOException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new IOException("Error getting DB connection.", e);
        }
        return connection;
    }

    protected QueryRunner createQueryRunner() {
        return new QueryRunner((DataSource)((Object)this.dataSource));
    }

    protected boolean allowsOnDuplicateKey() {
        return this.dataSource.allowsOnDuplicateKey();
    }

    public static class StringListHandler
    implements ResultSetHandler<ArrayList<String>> {
        public ArrayList<String> handle(ResultSet rs) throws SQLException {
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString(1));
            }
            return results;
        }
    }

    public static class IntListHandler
    implements ResultSetHandler<ArrayList<Integer>> {
        public ArrayList<Integer> handle(ResultSet rs) throws SQLException {
            ArrayList<Integer> results = new ArrayList<Integer>();
            while (rs.next()) {
                results.add(rs.getInt(1));
            }
            return results;
        }
    }

    public static class SingleStringHandler
    implements ResultSetHandler<String> {
        public String handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            return rs.getString(1);
        }
    }

    public static class IntHandler
    implements ResultSetHandler<Integer> {
        public Integer handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt(1);
        }
    }

    public static enum EncodingType {
        PLAIN(1),
        GZIP(2);

        private int numVal;

        private EncodingType(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static EncodingType fromInteger(int x) {
            switch (x) {
                case 1: {
                    return PLAIN;
                }
                case 2: {
                    return GZIP;
                }
            }
            return PLAIN;
        }
    }
}

