/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.util;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class FileClassNameScanner {
    public static Map<String, String> scan(String sourceDir) {
        return FileClassNameScanner.scan(sourceDir, null);
    }

    public static Map<String, String> scan(String sourceDir, String requiredExtension) {
        String sourceDirWithSeparator = sourceDir.endsWith(File.separator) ? sourceDir : sourceDir + File.separator;
        File dir = new File(sourceDirWithSeparator);
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyMap();
        }
        Collection files = FileUtils.listFiles((File)dir, null, (boolean)true);
        HashMap<String, String> classFileNames = new HashMap<String, String>();
        int prefixLength = sourceDirWithSeparator.length();
        for (File f : files) {
            String extension;
            assert (f.exists() && f.isFile());
            int extensionIndex = f.getName().lastIndexOf(46);
            String filePath = f.getPath();
            if (extensionIndex < 0 || !filePath.startsWith(sourceDirWithSeparator)) continue;
            int reverseExtensionIndex = f.getName().length() - extensionIndex;
            String classPathName = filePath.substring(prefixLength, filePath.length() - reverseExtensionIndex);
            if (classPathName.contains(".") || requiredExtension != null && !(extension = f.getName().substring(extensionIndex + 1)).equals(requiredExtension)) continue;
            classFileNames.put(classPathName.replace(File.separator, "."), filePath);
        }
        return classFileNames;
    }
}

