/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.resources;

import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.server.resources.BeanProvider;
import com.linkedin.restli.server.resources.Jsr330Adapter;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(InjectResourceFactory.class);
    private Map<String, ResourceModel> _rootResources;
    private Jsr330Adapter _jsr330Adapter;
    private final BeanProvider _beanProvider;

    public InjectResourceFactory(BeanProvider beanProvider) {
        this._beanProvider = beanProvider;
    }

    @Override
    public <R> R create(Class<R> resourceClass) {
        return this._jsr330Adapter.getBean(resourceClass);
    }

    @Override
    public void setRootResources(Map<String, ResourceModel> rootResources) {
        log.debug("Setting root resources");
        this._rootResources = rootResources;
        HashSet allResourceClasses = new HashSet();
        for (ResourceModel resourceModel : this._rootResources.values()) {
            this.processChildResource(resourceModel, allResourceClasses);
        }
        this._jsr330Adapter = new Jsr330Adapter(allResourceClasses, this._beanProvider);
    }

    protected void processChildResource(ResourceModel resourceModel, Collection<Class<?>> allResourceClasses) {
        if (resourceModel == null) {
            return;
        }
        log.debug("Adding resource class for DI: " + resourceModel.getResourceClass());
        allResourceClasses.add(resourceModel.getResourceClass());
        for (ResourceModel child : resourceModel.getSubResources()) {
            this.processChildResource(child, allResourceClasses);
        }
    }
}

