/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.restli.common.multiplexer.IndividualResponse;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.multiplexer.IndividualResponseException;
import com.linkedin.restli.server.multiplexer.IndividualResponseWithCookies;
import com.linkedin.restli.server.multiplexer.MultiplexerSingletonFilter;

final class ResponseFilterTask
extends BaseTask<IndividualResponseWithCookies> {
    private final MultiplexerSingletonFilter _multiplexerSingletonFilter;
    private final BaseTask<IndividualResponseWithCookies> _individualResponseWithCookies;

    ResponseFilterTask(MultiplexerSingletonFilter multiplexerSingletonFilter, BaseTask<IndividualResponseWithCookies> individualResponseWithCookies) {
        this._multiplexerSingletonFilter = multiplexerSingletonFilter;
        this._individualResponseWithCookies = individualResponseWithCookies;
    }

    protected Promise<? extends IndividualResponseWithCookies> run(Context context) throws Throwable {
        IndividualResponseWithCookies individualResponseWithCookies = (IndividualResponseWithCookies)this._individualResponseWithCookies.get();
        if (this._multiplexerSingletonFilter != null) {
            try {
                IndividualResponse filteredResponse = this._multiplexerSingletonFilter.filterIndividualResponse(individualResponseWithCookies.getIndividualResponse());
                return Promises.value((Object)new IndividualResponseWithCookies(filteredResponse, individualResponseWithCookies.getCookies()));
            }
            catch (RestLiServiceException e) {
                return Promises.value((Object)new IndividualResponseWithCookies(IndividualResponseException.createErrorIndividualResponse(e)));
            }
            catch (Exception e) {
                return Promises.value((Object)new IndividualResponseWithCookies(IndividualResponseException.createInternalServerErrorIndividualResponse(e)));
            }
        }
        return Promises.value((Object)individualResponseWithCookies);
    }
}

