/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.common.callback.Callback;
import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.restli.internal.server.RestLiMethodInvoker;
import com.linkedin.restli.server.multiplexer.MultiplexerRunMode;

final class RequestHandlingTask
extends BaseTask<RestResponse> {
    private final RestRequestHandler _requestHandler;
    private final BaseTask<RestRequest> _request;
    private final RequestContext _requestContext;
    private final MultiplexerRunMode _multiplexerRunMode;

    RequestHandlingTask(RestRequestHandler requestHandler, BaseTask<RestRequest> request, RequestContext requestContext, MultiplexerRunMode multiplexerRunMode) {
        this._requestHandler = requestHandler;
        this._request = request;
        this._requestContext = requestContext;
        this._multiplexerRunMode = multiplexerRunMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Promise<RestResponse> run(Context context) throws Throwable {
        final SettablePromise promise = Promises.settable();
        Callback<RestResponse> callback = new Callback<RestResponse>(){

            public void onError(Throwable e) {
                if (e instanceof RestException) {
                    promise.done((Object)((RestException)e).getResponse());
                } else {
                    promise.fail(e);
                }
            }

            public void onSuccess(RestResponse result) {
                promise.done((Object)result);
            }
        };
        if (this._request.isFailed()) {
            callback.onError(this._request.getError());
        } else {
            try {
                if (this._multiplexerRunMode == MultiplexerRunMode.SINGLE_PLAN) {
                    RestLiMethodInvoker.TASK_CONTEXT.set(context);
                }
                this._requestHandler.handleRequest((RestRequest)this._request.get(), this._requestContext, (Callback)callback);
            }
            catch (Exception e) {
                callback.onError((Throwable)e);
            }
            finally {
                if (this._multiplexerRunMode == MultiplexerRunMode.SINGLE_PLAN) {
                    RestLiMethodInvoker.TASK_CONTEXT.set(null);
                }
            }
        }
        return promise;
    }
}

