/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.annotations;

import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.server.ResourceConfigException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;

public class RestMethod {
    static Map<Class<? extends Annotation>, ResourceMethod> _restMethodAnnotationToResourceMethodMap;

    public static ResourceMethod getResourceMethod(Class<? extends Annotation> annotationClass) {
        return _restMethodAnnotationToResourceMethodMap.get(annotationClass);
    }

    static {
        Class<?>[] classes;
        _restMethodAnnotationToResourceMethodMap = new HashMap<Class<? extends Annotation>, ResourceMethod>();
        for (Class<?> restMethodClass : classes = RestMethod.class.getClasses()) {
            if (!Annotation.class.isAssignableFrom(restMethodClass)) continue;
            Class<Annotation> restMethodAnnotationClass = restMethodClass.asSubclass(Annotation.class);
            ToResourceMethod annotation = restMethodAnnotationClass.getAnnotation(ToResourceMethod.class);
            if (annotation == null) {
                throw new ResourceConfigException("Annotation " + restMethodAnnotationClass.getName() + " doesn't have ResourceMethod mapping");
            }
            ResourceMethod existingMapping = _restMethodAnnotationToResourceMethodMap.put(restMethodAnnotationClass, annotation.value());
            if (existingMapping == null) continue;
            throw new ResourceConfigException("Annotation " + restMethodAnnotationClass.getName() + " has multiple ResourceMethod mappings");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.GET_ALL)
    public static @interface GetAll {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.BATCH_DELETE)
    public static @interface BatchDelete {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.BATCH_PARTIAL_UPDATE)
    public static @interface BatchPartialUpdate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.BATCH_UPDATE)
    public static @interface BatchUpdate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.BATCH_CREATE)
    public static @interface BatchCreate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.BATCH_GET)
    public static @interface BatchGet {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.DELETE)
    public static @interface Delete {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.PARTIAL_UPDATE)
    public static @interface PartialUpdate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.UPDATE)
    public static @interface Update {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.CREATE)
    public static @interface Create {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ToResourceMethod(value=ResourceMethod.GET)
    public static @interface Get {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE})
    private static @interface ToResourceMethod {
        public ResourceMethod value();
    }
}

