/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.server.RestLiRequestData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestLiRequestDataImpl
implements RestLiRequestData {
    private Object _key;
    private RecordTemplate _entity;
    private final List<?> _keys;
    private final List<? extends RecordTemplate> _entities;
    private final Map<?, ? extends RecordTemplate> _keyEntityMap;

    @Override
    public Object getKey() {
        return this._key;
    }

    @Override
    public void setKey(Object key) {
        this._key = key;
    }

    @Override
    public List<?> getBatchKeys() {
        return this._keys;
    }

    @Override
    public RecordTemplate getEntity() {
        return this._entity;
    }

    @Override
    public void setEntity(RecordTemplate entity) {
        this._entity = entity;
    }

    @Override
    public List<? extends RecordTemplate> getBatchEntities() {
        return this._entities;
    }

    @Override
    public Map<?, ? extends RecordTemplate> getBatchKeyEntityMap() {
        return this._keyEntityMap;
    }

    @Override
    public boolean hasKey() {
        return this._key != null;
    }

    @Override
    public boolean hasBatchKeys() {
        return !this._keys.isEmpty();
    }

    @Override
    public boolean hasEntity() {
        return this._entity != null;
    }

    @Override
    public boolean hasBatchEntities() {
        return !this._entities.isEmpty();
    }

    @Override
    public boolean hasBatchKeyEntityMap() {
        return !this._keyEntityMap.isEmpty();
    }

    @Override
    public boolean isBatchRequest() {
        return this.hasBatchEntities() || this.hasBatchKeys() || this.hasBatchKeyEntityMap();
    }

    private RestLiRequestDataImpl(Object key, RecordTemplate entity, List<?> keys, List<? extends RecordTemplate> entities, Map<?, ? extends RecordTemplate> keyEntityMap) {
        this._key = key;
        this._entity = entity;
        this._keys = keys;
        this._entities = entities;
        this._keyEntityMap = keyEntityMap;
    }

    public static class Builder {
        private Object _key;
        private RecordTemplate _entity;
        private List<?> _keys = new ArrayList();
        private List<? extends RecordTemplate> _entities = new ArrayList<RecordTemplate>();
        private Map<?, ? extends RecordTemplate> _keyEntityMap = new HashMap();

        public Builder key(Object key) {
            this._key = key;
            return this;
        }

        public Builder entity(RecordTemplate entity) {
            this._entity = entity;
            return this;
        }

        public Builder batchKeys(Collection<?> keys) {
            this._keys = new ArrayList(keys);
            return this;
        }

        public Builder batchEntities(Collection<? extends RecordTemplate> entities) {
            this._entities = new ArrayList<RecordTemplate>(entities);
            return this;
        }

        public Builder batchKeyEntityMap(Map<?, ? extends RecordTemplate> map) {
            this._keyEntityMap = new HashMap(map);
            return this;
        }

        public RestLiRequestData build() {
            return new RestLiRequestDataImpl(this._key, this._entity, this._keys, this._entities, this._keyEntityMap);
        }
    }
}

