/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import java.util.EnumSet;

public class ErrorResponseFormat {
    public static final ErrorResponseFormat FULL = new ErrorResponseFormat(EnumSet.allOf(ErrorResponsePart.class));
    public static final ErrorResponseFormat MESSAGE_AND_DETAILS = new ErrorResponseFormat(EnumSet.of(ErrorResponsePart.MESSAGE, ErrorResponsePart.DETAILS, ErrorResponsePart.HEADERS));
    public static final ErrorResponseFormat MESSAGE_AND_SERVICECODE = new ErrorResponseFormat(EnumSet.of(ErrorResponsePart.STATUS_CODE_IN_BODY, ErrorResponsePart.MESSAGE, ErrorResponsePart.SERVICE_ERROR_CODE, ErrorResponsePart.HEADERS));
    public static final ErrorResponseFormat MESSAGE_AND_SERVICECODE_AND_EXCEPTIONCLASS = new ErrorResponseFormat(EnumSet.of(ErrorResponsePart.STATUS_CODE_IN_BODY, ErrorResponsePart.MESSAGE, ErrorResponsePart.SERVICE_ERROR_CODE, ErrorResponsePart.EXCEPTION_CLASS, ErrorResponsePart.HEADERS));
    public static final ErrorResponseFormat MESSAGE_ONLY = new ErrorResponseFormat(EnumSet.of(ErrorResponsePart.MESSAGE, ErrorResponsePart.HEADERS));
    public static final ErrorResponseFormat MINIMAL = new ErrorResponseFormat(EnumSet.of(ErrorResponsePart.HEADERS));
    private final EnumSet<ErrorResponsePart> _errorPartsToShow;

    public ErrorResponseFormat(EnumSet<ErrorResponsePart> errorPartsToShow) {
        this._errorPartsToShow = errorPartsToShow;
    }

    public static ErrorResponseFormat defaultFormat() {
        return FULL;
    }

    public boolean showHeaders() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.HEADERS);
    }

    public boolean showStatusCodeInBody() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.STATUS_CODE_IN_BODY);
    }

    public boolean showStacktrace() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.STACKTRACE);
    }

    public boolean showExceptionClass() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.EXCEPTION_CLASS);
    }

    public boolean showMessage() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.MESSAGE);
    }

    public boolean showServiceErrorCode() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.SERVICE_ERROR_CODE);
    }

    public boolean showDetails() {
        return this._errorPartsToShow.contains((Object)ErrorResponsePart.DETAILS);
    }

    public static enum ErrorResponsePart {
        HEADERS,
        STATUS_CODE_IN_BODY,
        STACKTRACE,
        EXCEPTION_CLASS,
        MESSAGE,
        SERVICE_ERROR_CODE,
        DETAILS;

    }
}

