/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.response.UpdateResponseEnvelope;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.UpdateResponse;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

public class UpdateResponseBuilder
implements RestLiResponseBuilder {
    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        return new PartialRestResponse.Builder().headers(responseData.getHeaders()).cookies(responseData.getCookies()).status(responseData.getStatus()).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        UpdateResponse updateResponse = (UpdateResponse)result;
        if (updateResponse.getStatus() == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. HttpStatus is null inside of a UpdateResponse returned by the resource method: " + routingResult.getResourceMethod());
        }
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(updateResponse.getStatus(), headers, cookies);
        responseData.setResponseEnvelope(new UpdateResponseEnvelope(responseData));
        return responseData;
    }
}

