/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.methods.MethodAdapterRegistry;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.response.ActionResponseEnvelope;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RestLiResponseHandler {
    private final MethodAdapterRegistry _methodAdapterRegistry;
    private final ErrorResponseBuilder _errorResponseBuilder;

    public RestLiResponseHandler(MethodAdapterRegistry methodAdapterRegistry, ErrorResponseBuilder errorResponseBuilder) {
        this._methodAdapterRegistry = methodAdapterRegistry;
        this._errorResponseBuilder = errorResponseBuilder;
    }

    public RestResponse buildResponse(RestRequest request, RoutingResult routingResult, Object responseObject) throws IOException {
        return this.buildResponse(routingResult, this.buildPartialResponse(routingResult, this.buildRestLiResponseData(request, routingResult, responseObject)));
    }

    public RestResponse buildResponse(RoutingResult routingResult, PartialRestResponse partialResponse) {
        List cookies = CookieUtil.encodeSetCookies(partialResponse.getCookies());
        RestResponseBuilder builder = (RestResponseBuilder)((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setHeaders(partialResponse.getHeaders())).setCookies(cookies)).setStatus(partialResponse.getStatus().getCode());
        if (partialResponse.hasData()) {
            DataMap dataMap = partialResponse.getDataMap();
            String mimeType = ((ServerResourceContext)routingResult.getContext()).getResponseMimeType();
            builder = this.encodeResult(mimeType, builder, dataMap);
        }
        return builder.build();
    }

    public PartialRestResponse buildPartialResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        if (responseData.isErrorResponse()) {
            return this._errorResponseBuilder.buildResponse(routingResult, responseData);
        }
        return this.chooseResponseBuilder(null, routingResult).buildResponse(routingResult, responseData);
    }

    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object responseObject) throws IOException {
        ServerResourceContext context = (ServerResourceContext)routingResult.getContext();
        ProtocolVersion protocolVersion = context.getRestliProtocolVersion();
        TreeMap<String, String> responseHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        responseHeaders.putAll(context.getResponseHeaders());
        responseHeaders.put("X-RestLi-Protocol-Version", protocolVersion.toString());
        List<HttpCookie> responseCookies = context.getResponseCookies();
        if (responseObject == null) {
            if (routingResult.getResourceMethod().getType().equals((Object)ResourceMethod.ACTION)) {
                RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(HttpStatus.S_200_OK, responseHeaders, responseCookies);
                responseData.setResponseEnvelope(new ActionResponseEnvelope(null, responseData));
                return responseData;
            }
            if (routingResult.getResourceMethod().getType().equals((Object)ResourceMethod.GET)) {
                throw new RestLiServiceException(HttpStatus.S_404_NOT_FOUND, "Requested entity not found: " + routingResult.getResourceMethod());
            }
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null returned by the resource method: " + routingResult.getResourceMethod());
        }
        RestLiResponseBuilder responseBuilder = this.chooseResponseBuilder(responseObject, routingResult);
        if (responseBuilder == null) {
            ResourceMethodDescriptor resourceMethod = routingResult.getResourceMethod();
            String fqMethodName = resourceMethod.getResourceModel().getResourceClass().getName() + '#' + routingResult.getResourceMethod().getMethod().getName();
            throw new RestLiInternalException("Invalid return type '" + responseObject.getClass() + " from method '" + fqMethodName + '\'');
        }
        return responseBuilder.buildRestLiResponseData(request, routingResult, responseObject, responseHeaders, responseCookies);
    }

    public RestLiResponseData buildExceptionResponseData(RestRequest request, RoutingResult routingResult, Object object, Map<String, String> headers, List<HttpCookie> cookies) {
        return this._errorResponseBuilder.buildRestLiResponseData(request, routingResult, object, headers, cookies);
    }

    public RestException buildRestException(Throwable e, PartialRestResponse partialResponse) {
        List cookies = CookieUtil.encodeSetCookies(partialResponse.getCookies());
        RestResponseBuilder builder = (RestResponseBuilder)((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setHeaders(partialResponse.getHeaders())).setCookies(cookies)).setStatus(partialResponse.getStatus().getCode());
        if (partialResponse.hasData()) {
            DataMap dataMap = partialResponse.getDataMap();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            DataMapUtils.write(dataMap, null, baos, true);
            builder.setEntity(baos.toByteArray());
        }
        RestResponse restResponse = builder.build();
        RestException restException = new RestException(restResponse, e);
        return restException;
    }

    private RestResponseBuilder encodeResult(String mimeType, RestResponseBuilder builder, DataMap dataMap) {
        if ("application/x-pson".equalsIgnoreCase(mimeType)) {
            builder.setHeader("Content-Type", "application/x-pson");
            builder.setEntity(DataMapUtils.mapToPsonByteString(dataMap));
        } else if ("application/json".equalsIgnoreCase(mimeType)) {
            builder.setHeader("Content-Type", "application/json");
            builder.setEntity(DataMapUtils.mapToByteString(dataMap));
        } else {
            throw new RoutingException("No acceptable types can be returned", HttpStatus.S_406_NOT_ACCEPTABLE.getCode());
        }
        return builder;
    }

    private RestLiResponseBuilder chooseResponseBuilder(Object responseObject, RoutingResult routingResult) {
        if (responseObject != null && responseObject instanceof RestLiServiceException) {
            return this._errorResponseBuilder;
        }
        return this._methodAdapterRegistry.getResponsebuilder(routingResult.getResourceMethod().getType());
    }

    public static class Builder {
        private MethodAdapterRegistry _methodAdapterRegistry = null;
        private ErrorResponseBuilder _errorResponseBuilder = null;
        private boolean _permissiveEncoding = false;

        public Builder setMethodAdapterRegistry(MethodAdapterRegistry methodAdapterRegistry) {
            this._methodAdapterRegistry = methodAdapterRegistry;
            return this;
        }

        public Builder setErrorResponseBuilder(ErrorResponseBuilder errorResponseBuilder) {
            this._errorResponseBuilder = errorResponseBuilder;
            return this;
        }

        public RestLiResponseHandler build() {
            if (this._errorResponseBuilder == null) {
                this._errorResponseBuilder = new ErrorResponseBuilder();
            }
            if (this._methodAdapterRegistry == null) {
                this._methodAdapterRegistry = new MethodAdapterRegistry(this._errorResponseBuilder);
            }
            return new RestLiResponseHandler(this._methodAdapterRegistry, this._errorResponseBuilder);
        }
    }
}

