/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.server.ResponseType;
import com.linkedin.restli.internal.server.response.ActionResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchCreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchDeleteResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchGetResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchPartialUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.CollectionResponseEnvelope;
import com.linkedin.restli.internal.server.response.CreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.DeleteResponseEnvelope;
import com.linkedin.restli.internal.server.response.EmptyResponseEnvelope;
import com.linkedin.restli.internal.server.response.FinderResponseEnvelope;
import com.linkedin.restli.internal.server.response.GetAllResponseEnvelope;
import com.linkedin.restli.internal.server.response.GetResponseEnvelope;
import com.linkedin.restli.internal.server.response.OptionsResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.RecordResponseEnvelope;
import com.linkedin.restli.internal.server.response.RestLiResponseEnvelope;
import com.linkedin.restli.internal.server.response.UpdateResponseEnvelope;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RestLiResponseDataImpl
implements RestLiResponseData {
    private HttpStatus _status;
    private Map<String, String> _headers;
    private List<HttpCookie> _cookies;
    private RestLiServiceException _exception;
    private RestLiResponseEnvelope _responseEnvelope;

    private RestLiResponseDataImpl(Map<String, String> headers, List<HttpCookie> cookies) {
        this._headers = new TreeMap<String, String>(headers);
        this._cookies = cookies;
    }

    public RestLiResponseDataImpl(HttpStatus httpStatus, Map<String, String> headers, List<HttpCookie> cookies) {
        this(headers, cookies);
        this.setStatus(httpStatus);
    }

    public RestLiResponseDataImpl(RestLiServiceException exception, Map<String, String> headers, List<HttpCookie> cookies) {
        this(headers, cookies);
        this.setServiceException(exception);
    }

    void setResponseEnvelope(RestLiResponseEnvelope responseEnvelope) {
        this._responseEnvelope = responseEnvelope;
        if (this.isErrorResponse()) {
            this._responseEnvelope.clearData();
        }
    }

    public void setException(Throwable throwable) {
        RestLiServiceException restLiServiceException;
        if (throwable == null) {
            throw new UnsupportedOperationException("Null is not permitted in setting an exception.");
        }
        if (throwable instanceof RestLiServiceException) {
            restLiServiceException = (RestLiServiceException)throwable;
        } else if (throwable instanceof RoutingException) {
            RoutingException routingException = (RoutingException)throwable;
            restLiServiceException = new RestLiServiceException(HttpStatus.fromCode((int)routingException.getStatus()), routingException.getMessage(), routingException);
        } else {
            restLiServiceException = new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, throwable.getMessage(), throwable);
        }
        this.setServiceException(restLiServiceException);
    }

    private void setServiceException(RestLiServiceException exception) {
        if (exception == null) {
            throw new UnsupportedOperationException("Null is not permitted in setting an exception.");
        }
        this._exception = exception;
        this._status = null;
        if (this._responseEnvelope != null) {
            this._responseEnvelope.clearData();
        }
    }

    @Override
    public boolean isErrorResponse() {
        return this._exception != null;
    }

    @Override
    public RestLiServiceException getServiceException() {
        return this._exception;
    }

    @Override
    public HttpStatus getStatus() {
        return this._exception != null ? this._exception.getStatus() : this._status;
    }

    @Override
    public ResponseType getResponseType() {
        return this._responseEnvelope.getResponseType();
    }

    @Override
    public ResourceMethod getResourceMethod() {
        return this._responseEnvelope.getResourceMethod();
    }

    void setStatus(HttpStatus status) {
        if (status == null) {
            throw new UnsupportedOperationException("Setting status to null is not permitted for when there are no exceptions.");
        }
        this._status = status;
        this._exception = null;
        this._headers.remove(HeaderUtil.getErrorResponseHeaderName(this._headers));
    }

    @Override
    public Map<String, String> getHeaders() {
        return this._headers;
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this._cookies;
    }

    @Override
    public RecordResponseEnvelope getRecordResponseEnvelope() {
        try {
            return (RecordResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public CollectionResponseEnvelope getCollectionResponseEnvelope() {
        try {
            return (CollectionResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchResponseEnvelope getBatchResponseEnvelope() {
        try {
            return (BatchResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public EmptyResponseEnvelope getEmptyResponseEnvelope() {
        try {
            return (EmptyResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public ActionResponseEnvelope getActionResponseEnvelope() {
        try {
            return (ActionResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchCreateResponseEnvelope getBatchCreateResponseEnvelope() {
        try {
            return (BatchCreateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchDeleteResponseEnvelope getBatchDeleteResponseEnvelope() {
        try {
            return (BatchDeleteResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchGetResponseEnvelope getBatchGetResponseEnvelope() {
        try {
            return (BatchGetResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchPartialUpdateResponseEnvelope getBatchPartialUpdateResponseEnvelope() {
        try {
            return (BatchPartialUpdateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BatchUpdateResponseEnvelope getBatchUpdateResponseEnvelope() {
        try {
            return (BatchUpdateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public CreateResponseEnvelope getCreateResponseEnvelope() {
        try {
            return (CreateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public DeleteResponseEnvelope getDeleteResponseEnvelope() {
        try {
            return (DeleteResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public FinderResponseEnvelope getFinderResponseEnvelope() {
        try {
            return (FinderResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public GetAllResponseEnvelope getGetAllResponseEnvelope() {
        try {
            return (GetAllResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public GetResponseEnvelope getGetResponseEnvelope() {
        try {
            return (GetResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public OptionsResponseEnvelope getOptionsResponseEnvelope() {
        try {
            return (OptionsResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public PartialUpdateResponseEnvelope getPartialUpdateResponseEnvelope() {
        try {
            return (PartialUpdateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public UpdateResponseEnvelope getUpdateResponseEnvelope() {
        try {
            return (UpdateResponseEnvelope)this._responseEnvelope;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }
}

