/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.EmptyRecord;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.response.ActionResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchCreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchDeleteResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchGetResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchPartialUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.BatchUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.CreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.DeleteResponseEnvelope;
import com.linkedin.restli.internal.server.response.FinderResponseEnvelope;
import com.linkedin.restli.internal.server.response.GetAllResponseEnvelope;
import com.linkedin.restli.internal.server.response.GetResponseEnvelope;
import com.linkedin.restli.internal.server.response.OptionsResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialUpdateResponseEnvelope;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.response.RestLiResponseEnvelope;
import com.linkedin.restli.internal.server.response.UpdateResponseEnvelope;
import java.util.Collections;

class EnvelopeBuilderUtil {
    EnvelopeBuilderUtil() {
    }

    public static RestLiResponseEnvelope buildBlankResponseEnvelope(ResourceMethod resourceMethod, RestLiResponseDataImpl responseData) {
        switch (resourceMethod) {
            case GET: {
                return new GetResponseEnvelope((RecordTemplate)new EmptyRecord(), responseData);
            }
            case CREATE: {
                return new CreateResponseEnvelope((RecordTemplate)new EmptyRecord(), responseData);
            }
            case ACTION: {
                return new ActionResponseEnvelope((RecordTemplate)new EmptyRecord(), responseData);
            }
            case GET_ALL: {
                return new GetAllResponseEnvelope(Collections.emptyList(), null, (RecordTemplate)new EmptyRecord(), responseData);
            }
            case FINDER: {
                return new FinderResponseEnvelope(Collections.emptyList(), null, (RecordTemplate)new EmptyRecord(), responseData);
            }
            case BATCH_CREATE: {
                return new BatchCreateResponseEnvelope(Collections.emptyList(), responseData);
            }
            case BATCH_GET: {
                return new BatchGetResponseEnvelope(Collections.emptyMap(), responseData);
            }
            case BATCH_UPDATE: {
                return new BatchUpdateResponseEnvelope(Collections.emptyMap(), responseData);
            }
            case BATCH_PARTIAL_UPDATE: {
                return new BatchPartialUpdateResponseEnvelope(Collections.emptyMap(), responseData);
            }
            case BATCH_DELETE: {
                return new BatchDeleteResponseEnvelope(Collections.emptyMap(), responseData);
            }
            case PARTIAL_UPDATE: {
                return new PartialUpdateResponseEnvelope(responseData);
            }
            case UPDATE: {
                return new UpdateResponseEnvelope(responseData);
            }
            case DELETE: {
                return new DeleteResponseEnvelope(responseData);
            }
            case OPTIONS: {
                return new OptionsResponseEnvelope(responseData);
            }
        }
        throw new IllegalStateException();
    }
}

