/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods.arguments;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DynamicRecordTemplate;
import com.linkedin.data.template.InvalidAlternativeKeyException;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.BatchRequest;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.common.validation.RestLiDataValidator;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.util.AlternativeKeyCoercerException;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.Key;
import com.linkedin.restli.server.PagingContext;
import com.linkedin.restli.server.ResourceConfigException;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import com.linkedin.restli.server.annotations.HeaderParam;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgumentBuilder {
    public static Object[] buildArgs(Object[] positionalArguments, ResourceMethodDescriptor resourceMethod, ResourceContext context, DynamicRecordTemplate template) {
        List<Parameter<?>> parameters = resourceMethod.getParameters();
        Object[] arguments = Arrays.copyOf(positionalArguments, parameters.size());
        ArgumentBuilder.fixUpComplexKeySingletonArraysInArguments(arguments);
        boolean attachmentsDesired = false;
        for (int i = positionalArguments.length; i < parameters.size(); ++i) {
            Parameter<?> param;
            block26: {
                param = parameters.get(i);
                try {
                    Object value;
                    if (param.getParamType() == Parameter.ParamType.KEY || param.getParamType() == Parameter.ParamType.ASSOC_KEY_PARAM) {
                        value = context.getPathKeys().get(param.getName());
                        if (value != null) {
                            arguments[i] = value;
                            continue;
                        }
                        break block26;
                    }
                    if (param.getParamType() == Parameter.ParamType.CALLBACK || param.getParamType() == Parameter.ParamType.PARSEQ_CONTEXT_PARAM || param.getParamType() == Parameter.ParamType.PARSEQ_CONTEXT) continue;
                    if (param.getParamType() == Parameter.ParamType.HEADER) {
                        HeaderParam headerParam = param.getAnnotations().get(HeaderParam.class);
                        String value2 = context.getRequestHeaders().get(headerParam.value());
                        arguments[i] = value2;
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.PROJECTION || param.getParamType() == Parameter.ParamType.PROJECTION_PARAM) {
                        arguments[i] = context.getProjectionMask();
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.METADATA_PROJECTION_PARAM) {
                        arguments[i] = context.getMetadataProjectionMask();
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.PAGING_PROJECTION_PARAM) {
                        arguments[i] = context.getPagingProjectionMask();
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.CONTEXT || param.getParamType() == Parameter.ParamType.PAGING_CONTEXT_PARAM) {
                        PagingContext ctx = RestUtils.getPagingContext(context, (PagingContext)param.getDefaultValue());
                        arguments[i] = ctx;
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.PATH_KEYS || param.getParamType() == Parameter.ParamType.PATH_KEYS_PARAM) {
                        arguments[i] = context.getPathKeys();
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.PATH_KEY_PARAM) {
                        value = context.getPathKeys().get(param.getName());
                        if (value != null) {
                            arguments[i] = value;
                            continue;
                        }
                        break block26;
                    }
                    if (param.getParamType() == Parameter.ParamType.RESOURCE_CONTEXT || param.getParamType() == Parameter.ParamType.RESOURCE_CONTEXT_PARAM) {
                        arguments[i] = context;
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.VALIDATOR_PARAM) {
                        RestLiDataValidator validator = new RestLiDataValidator(resourceMethod.getResourceModel().getResourceClass().getAnnotations(), resourceMethod.getResourceModel().getValueClass(), resourceMethod.getMethodType());
                        arguments[i] = validator;
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.RESTLI_ATTACHMENTS_PARAM) {
                        arguments[i] = ((ServerResourceContext)context).getRequestAttachmentReader();
                        attachmentsDesired = true;
                        continue;
                    }
                    if (param.getParamType() == Parameter.ParamType.POST) {
                        DataMap data;
                        if (template != null && (data = template.data()).containsKey((Object)param.getName())) {
                            arguments[i] = template.getValue(param);
                            continue;
                        }
                        break block26;
                    }
                    if (param.getParamType() == Parameter.ParamType.QUERY) {
                        value = DataTemplate.class.isAssignableFrom(param.getType()) ? ArgumentBuilder.buildDataTemplateArgument(context, param) : ArgumentBuilder.buildRegularArgument(context, param);
                        if (value != null) {
                            arguments[i] = value;
                            continue;
                        }
                        break block26;
                    }
                    if (param.getParamType() == Parameter.ParamType.BATCH || param.getParamType() == Parameter.ParamType.RESOURCE_KEY) {
                        throw new RoutingException("Parameter '" + param.getName() + "' should be passed in as a positional argument", HttpStatus.S_400_BAD_REQUEST.getCode());
                    }
                    throw new RoutingException("Parameter '" + param.getName() + "' has an unknown parameter type '" + param.getParamType().name() + "'", HttpStatus.S_400_BAD_REQUEST.getCode());
                }
                catch (TemplateRuntimeException e) {
                    throw new RoutingException("Parameter '" + param.getName() + "' is invalid", HttpStatus.S_400_BAD_REQUEST.getCode());
                }
            }
            try {
                if (param.isOptional() && param.hasDefaultValue()) {
                    arguments[i] = param.getDefaultValue();
                    continue;
                }
                if (param.isOptional() && !param.getType().isPrimitive()) {
                    arguments[i] = null;
                    continue;
                }
                throw new RoutingException("Parameter '" + param.getName() + "' is required", HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            catch (ResourceConfigException e) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Parameter '" + param.getName() + "' default value is invalid", e);
            }
        }
        if (!attachmentsDesired && ((ServerResourceContext)context).getRequestAttachmentReader() != null) {
            throw new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "Resource method endpoint invoked does not accept any request attachments.");
        }
        return arguments;
    }

    private static void fixUpComplexKeySingletonArraysInArguments(Object[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object k = arguments[i];
            if (!(k instanceof ComplexResourceKey)) continue;
            ComplexResourceKey complexResourceKey = (ComplexResourceKey)k;
            ComplexResourceKey newKey = QueryParamsDataMap.fixUpComplexKeySingletonArray((ComplexResourceKey)complexResourceKey);
            arguments[i] = newKey;
        }
    }

    private static Object buildArrayArgument(ResourceContext context, Parameter<?> param) {
        Object convertedValue;
        if (DataTemplate.class.isAssignableFrom(param.getItemType())) {
            DataList itemsList = (DataList)context.getStructuredParameter(param.getName());
            convertedValue = Array.newInstance(param.getItemType(), itemsList.size());
            int j = 0;
            for (Object paramData : itemsList) {
                DataTemplate itemsElem = DataTemplateUtil.wrap(paramData, param.getItemType().asSubclass(DataTemplate.class));
                ValidateDataAgainstSchema.validate((Object)itemsElem.data(), (DataSchema)itemsElem.schema(), (ValidationOptions)new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE));
                Array.set(convertedValue, j++, itemsElem);
            }
        } else {
            List<String> itemStringValues = context.getParameterValues(param.getName());
            ArrayDataSchema parameterSchema = null;
            if (!(param.getDataSchema() instanceof ArrayDataSchema)) {
                throw new RoutingException("An array schema is expected.", HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            parameterSchema = (ArrayDataSchema)param.getDataSchema();
            convertedValue = Array.newInstance(param.getItemType(), itemStringValues.size());
            int j = 0;
            for (String itemStringValue : itemStringValues) {
                if (itemStringValue == null) {
                    throw new RoutingException("Parameter '" + param.getName() + "' cannot contain null values", HttpStatus.S_400_BAD_REQUEST.getCode());
                }
                try {
                    Array.set(convertedValue, j++, ArgumentUtils.convertSimpleValue(itemStringValue, parameterSchema.getItems(), param.getItemType()));
                }
                catch (NumberFormatException e) {
                    Class targetClass = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)parameterSchema.getItems().getDereferencedType());
                    throw new RoutingException(String.format("Array parameter '%s' value '%s' must be of type '%s'", param.getName(), itemStringValue, targetClass.getName()), HttpStatus.S_400_BAD_REQUEST.getCode());
                }
                catch (IllegalArgumentException e) {
                    throw new RoutingException(String.format("Array parameter '%s' value '%s' is invalid", param.getName(), itemStringValue), HttpStatus.S_400_BAD_REQUEST.getCode());
                }
                catch (TemplateRuntimeException e) {
                    throw new RoutingException(String.format("Array parameter '%s' value '%s' is invalid. Reason: %s", param.getName(), itemStringValue, e.getMessage()), HttpStatus.S_400_BAD_REQUEST.getCode());
                }
            }
        }
        return convertedValue;
    }

    private static Object buildRegularArgument(ResourceContext context, Parameter<?> param) {
        Object convertedValue;
        String value = ArgumentUtils.argumentAsString(context.getParameter(param.getName()), param.getName());
        if (value == null) {
            return null;
        }
        if (param.isArray()) {
            convertedValue = ArgumentBuilder.buildArrayArgument(context, param);
        } else {
            try {
                convertedValue = ArgumentUtils.convertSimpleValue(value, param.getDataSchema(), param.getType());
            }
            catch (NumberFormatException e) {
                Class targetClass = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)param.getDataSchema().getDereferencedType());
                throw new RoutingException(String.format("Argument parameter '%s' value '%s' must be of type '%s'", param.getName(), value, targetClass.getName()), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            catch (IllegalArgumentException e) {
                throw new RoutingException(String.format("Argument parameter '%s' value '%s' is invalid", param.getName(), value), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            catch (TemplateRuntimeException e) {
                throw new RoutingException(String.format("Argument parameter '%s' value '%s' is invalid. Reason: %s", param.getName(), value, e.getMessage()), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
        }
        return convertedValue;
    }

    private static DataTemplate<?> buildDataTemplateArgument(ResourceContext context, Parameter<?> param) {
        Object paramValue = context.getStructuredParameter(param.getName());
        if (paramValue == null) {
            return null;
        }
        Class paramType = param.getType();
        DataTemplate paramRecordTemplate = AbstractArrayTemplate.class.isAssignableFrom(paramType) && paramValue.getClass() != DataList.class ? DataTemplateUtil.wrap((Object)new DataList(Arrays.asList(paramValue)), (Class)paramType) : DataTemplateUtil.wrap((Object)paramValue, (Class)paramType);
        ValidateDataAgainstSchema.validate((Object)paramRecordTemplate.data(), (DataSchema)paramRecordTemplate.schema(), (ValidationOptions)new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE));
        return paramRecordTemplate;
    }

    public static <V extends RecordTemplate> V extractEntity(RestRequest request, Class<V> recordClass) {
        try {
            return DataMapUtils.read((RestMessage)request, recordClass);
        }
        catch (IOException e) {
            throw new RoutingException("Error parsing entity body: " + e.getMessage(), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
    }

    static <R extends RecordTemplate> Map<Object, R> buildBatchRequestMap(RoutingResult routingResult, DataMap data, Class<R> valueClass, Set<?> ids, ProtocolVersion version) {
        if (ids == null) {
            return null;
        }
        BatchRequest batchRequest = new BatchRequest(data, new TypeSpec(valueClass));
        HashMap<Object, RecordTemplate> result = new HashMap<Object, RecordTemplate>(CollectionUtils.getMapInitialCapacity((int)batchRequest.getEntities().size(), (float)0.75f), 0.75f);
        for (Map.Entry entry : batchRequest.getEntities().entrySet()) {
            Object typedKey = ArgumentBuilder.parseEntityStringKey((String)entry.getKey(), routingResult, version);
            if (result.containsKey(typedKey)) {
                throw new RoutingException(String.format("Duplicate key in batch request body: '%s'", typedKey), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            if (!ids.contains(typedKey)) {
                throw new RoutingException(String.format("Batch request mismatch. Entity key '%s' not found in the query parameter.", typedKey), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            RecordTemplate value = (RecordTemplate)DataTemplateUtil.wrap((Object)((RecordTemplate)entry.getValue()).data(), valueClass);
            result.put(typedKey, value);
        }
        if (!ids.equals(result.keySet())) {
            throw new RoutingException(String.format("Batch request mismatch. URI keys: '%s' Entity keys: '%s'", ids.toString(), result.keySet().toString()), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        return result;
    }

    static Object parseEntityStringKey(String stringKey, RoutingResult routingResult, ProtocolVersion version) {
        ResourceModel resourceModel = routingResult.getResourceMethod().getResourceModel();
        ResourceContext resourceContext = routingResult.getContext();
        try {
            Key primaryKey = resourceModel.getPrimaryKey();
            String altKeyName = resourceContext.getParameter("altkey");
            if (altKeyName != null) {
                return ArgumentUtils.translateFromAlternativeKey(ArgumentUtils.parseAlternativeKey(stringKey, altKeyName, resourceModel, version), altKeyName, resourceModel);
            }
            if (ComplexResourceKey.class.equals(primaryKey.getType())) {
                return ComplexResourceKey.parseString((String)stringKey, resourceModel.getKeyKeyClass(), resourceModel.getKeyParamsClass(), (ProtocolVersion)version);
            }
            if (CompoundKey.class.equals(primaryKey.getType())) {
                return ArgumentUtils.parseCompoundKey(stringKey, resourceModel.getKeys(), version);
            }
            Key key = resourceModel.getPrimaryKey();
            return ArgumentUtils.convertSimpleValue(stringKey, key.getDataSchema(), key.getType());
        }
        catch (InvalidAlternativeKeyException | PathSegment.PathSegmentSyntaxException | AlternativeKeyCoercerException | IllegalArgumentException e) {
            throw new RoutingException(String.format("Invalid key: '%s'", stringKey), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
    }
}

