/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods.arguments;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.DynamicRecordTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.arguments.ArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiRequestDataImpl;
import com.linkedin.restli.server.RoutingException;

public class ActionArgumentBuilder
implements RestLiArgumentBuilder {
    @Override
    public Object[] buildArguments(RestLiRequestData requestData, RoutingResult routingResult) {
        DynamicRecordTemplate template = (DynamicRecordTemplate)requestData.getEntity();
        return ArgumentBuilder.buildArgs(new Object[0], routingResult.getResourceMethod(), routingResult.getContext(), template);
    }

    @Override
    public RestLiRequestData extractRequestData(RoutingResult routingResult, RestRequest request) {
        DynamicRecordTemplate template;
        ResourceMethodDescriptor resourceMethodDescriptor = routingResult.getResourceMethod();
        DataMap data = request.getEntity() == null || request.getEntity().length() == 0 ? new DataMap() : DataMapUtils.readMap((RestMessage)request);
        ValidationResult result = ValidateDataAgainstSchema.validate((Object)data, (DataSchema)(template = new DynamicRecordTemplate(data, resourceMethodDescriptor.getRequestDataSchema())).schema(), (ValidationOptions)new ValidationOptions(RequiredMode.IGNORE, CoercionMode.NORMAL));
        if (!result.isValid()) {
            throw new RoutingException("Parameters of method '" + resourceMethodDescriptor.getActionName() + "' failed validation with error '" + result.getMessages() + "'", HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        return new RestLiRequestDataImpl.Builder().entity((RecordTemplate)template).build();
    }
}

