/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.filter;

import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.server.RestLiCallback;
import com.linkedin.restli.internal.server.RestLiMethodInvoker;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.filter.FilterChainCallback;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseHandler;
import com.linkedin.restli.server.RequestExecutionCallback;
import com.linkedin.restli.server.RequestExecutionReport;
import com.linkedin.restli.server.RequestExecutionReportBuilder;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;

public class FilterChainCallbackImpl
implements FilterChainCallback {
    private RoutingResult _method;
    private RestLiMethodInvoker _methodInvoker;
    private RestLiArgumentBuilder _restLiArgumentBuilder;
    private RequestExecutionReportBuilder _requestExecutionReportBuilder;
    private RestLiAttachmentReader _requestAttachmentReader;
    private RestLiResponseHandler _responseHandler;
    private RequestExecutionCallback<RestResponse> _wrappedCallback;

    public FilterChainCallbackImpl(RoutingResult method, RestLiMethodInvoker methodInvoker, RestLiArgumentBuilder adapter, RequestExecutionReportBuilder requestExecutionReportBuilder, RestLiAttachmentReader requestAttachmentReader, RestLiResponseHandler responseHandler, RequestExecutionCallback<RestResponse> wrappedCallback) {
        this._method = method;
        this._methodInvoker = methodInvoker;
        this._restLiArgumentBuilder = adapter;
        this._requestExecutionReportBuilder = requestExecutionReportBuilder;
        this._requestAttachmentReader = requestAttachmentReader;
        this._responseHandler = responseHandler;
        this._wrappedCallback = wrappedCallback;
    }

    @Override
    public void onRequestSuccess(RestLiRequestData requestData, RestLiCallback<Object> restLiCallback) {
        this._methodInvoker.invoke(requestData, this._method, this._restLiArgumentBuilder, restLiCallback, this._requestExecutionReportBuilder);
    }

    @Override
    public void onResponseSuccess(RestLiResponseData responseData, RestLiResponseAttachments responseAttachments) {
        PartialRestResponse response = this._responseHandler.buildPartialResponse(this._method, responseData);
        this._wrappedCallback.onSuccess(this._responseHandler.buildResponse(this._method, response), this.getRequestExecutionReport(), responseAttachments);
    }

    @Override
    public void onError(Throwable th, RestLiResponseData responseData, RestLiResponseAttachments responseAttachments) {
        RestLiServiceException e = responseData.getServiceException();
        PartialRestResponse response = this._responseHandler.buildPartialResponse(this._method, responseData);
        this._wrappedCallback.onError((Throwable)this._responseHandler.buildRestException(e, response), this.getRequestExecutionReport(), this._requestAttachmentReader, responseAttachments);
    }

    private RequestExecutionReport getRequestExecutionReport() {
        return this._requestExecutionReportBuilder == null ? null : this._requestExecutionReportBuilder.build();
    }
}

