/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.StringDatasetVersion;
import org.apache.gobblin.data.management.version.finder.DatasetVersionFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkDatasetVersionFinder
extends DatasetVersionFinder<StringDatasetVersion> {
    public static final Logger LOGGER = LoggerFactory.getLogger(WatermarkDatasetVersionFinder.class);
    public static final String WATERMARK_REGEX_KEY = "version.watermark.regex";
    private Optional<Pattern> pattern;

    public WatermarkDatasetVersionFinder(FileSystem fs, Properties props) {
        this(fs, ConfigFactory.parseProperties((Properties)props));
    }

    public WatermarkDatasetVersionFinder(FileSystem fs, Config config) {
        super(fs);
        if (config.hasPath(WATERMARK_REGEX_KEY)) {
            this.initPattern(config.getString(WATERMARK_REGEX_KEY));
        } else {
            this.pattern = Optional.absent();
        }
    }

    private void initPattern(String patternString) {
        this.pattern = Optional.of((Object)patternString).transform((Function)new Function<String, Pattern>(){

            @Nullable
            public Pattern apply(String input) {
                return Pattern.compile(input);
            }
        });
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return StringDatasetVersion.class;
    }

    @Override
    public Path globVersionPattern() {
        return new Path("*");
    }

    @Override
    public StringDatasetVersion getDatasetVersion(Path pathRelativeToDatasetRoot, Path fullPath) {
        if (this.pattern.isPresent()) {
            Matcher matcher = ((Pattern)this.pattern.get()).matcher(pathRelativeToDatasetRoot.getName());
            if (!matcher.find() || matcher.groupCount() < 1) {
                LOGGER.warn("Candidate dataset version at " + pathRelativeToDatasetRoot + " does not match expected pattern. Ignoring.");
                return null;
            }
            return new StringDatasetVersion(matcher.group(1), fullPath);
        }
        return new StringDatasetVersion(pathRelativeToDatasetRoot.getName(), fullPath);
    }
}

