/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class AbstractDatasetVersionFinder<T extends FileSystemDatasetVersion>
implements VersionFinder<T> {
    protected FileSystem fs;

    public AbstractDatasetVersionFinder(FileSystem fs, Properties props) {
        this.fs = fs;
    }

    public AbstractDatasetVersionFinder(FileSystem fs) {
        this(fs, new Properties());
    }

    @Override
    public Collection<T> findDatasetVersions(Dataset dataset) throws IOException {
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        Path versionGlobStatus = new Path(fsDataset.datasetRoot(), this.globVersionPattern());
        FileStatus[] dataSetVersionPaths = this.fs.globStatus(versionGlobStatus);
        ArrayList dataSetVersions = Lists.newArrayList();
        for (FileStatus dataSetVersionPath : dataSetVersionPaths) {
            T datasetVersion = this.getDatasetVersion(PathUtils.relativizePath((Path)dataSetVersionPath.getPath(), (Path)fsDataset.datasetRoot()), dataSetVersionPath);
            if (datasetVersion == null) continue;
            dataSetVersions.add(datasetVersion);
        }
        return dataSetVersions;
    }

    @Override
    public abstract Class<? extends FileSystemDatasetVersion> versionClass();

    public abstract Path globVersionPattern();

    public abstract T getDatasetVersion(Path var1, FileStatus var2);
}

