/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveFileSet;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePartitionFileSet
extends HiveFileSet {
    private static final Logger log = LoggerFactory.getLogger(HivePartitionFileSet.class);
    private HiveCopyEntityHelper hiveCopyEntityHelper;
    private final Partition partition;
    private final Properties properties;
    private Optional<Partition> existingTargetPartition;
    private final EventSubmitter eventSubmitter;

    public HivePartitionFileSet(HiveCopyEntityHelper hiveCopyEntityHelper, Partition partition, Properties properties) {
        super(partition.getCompleteName(), hiveCopyEntityHelper.getDataset());
        this.hiveCopyEntityHelper = hiveCopyEntityHelper;
        this.partition = partition;
        this.properties = properties;
        this.existingTargetPartition = Optional.fromNullable((Object)this.hiveCopyEntityHelper.getTargetPartitions().get(this.partition.getValues()));
        this.eventSubmitter = new EventSubmitter.Builder(this.hiveCopyEntityHelper.getDataset().getMetricContext(), "hive.dataset.copy").addMetadata("Partition", this.partition.getName()).build();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Collection<CopyEntity> generateCopyEntities() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Partition getTargetPartition(Partition originPartition, Path targetLocation) throws IOException {
        try {
            Partition targetPartition = new Partition(this.hiveCopyEntityHelper.getTargetTable(), originPartition.getTPartition().deepCopy());
            targetPartition.getTable().setDbName(this.hiveCopyEntityHelper.getTargetDatabase());
            targetPartition.getTPartition().setDbName(this.hiveCopyEntityHelper.getTargetDatabase());
            targetPartition.getTPartition().putToParameters("registerer", "gobblin-distcp");
            targetPartition.getTPartition().putToParameters("registrationGenerationTimeMillis", Long.toString(this.hiveCopyEntityHelper.getStartTime()));
            targetPartition.setLocation(targetLocation.toString());
            targetPartition.getTPartition().unsetCreateTime();
            return targetPartition;
        }
        catch (HiveException he) {
            throw new IOException(he);
        }
    }

    private static void checkPartitionCompatibility(Partition desiredTargetPartition, Partition existingTargetPartition) throws IOException {
        if (!desiredTargetPartition.getDataLocation().equals((Object)existingTargetPartition.getDataLocation())) {
            throw new IOException(String.format("Desired target location %s and already registered target location %s do not agree.", desiredTargetPartition.getDataLocation(), existingTargetPartition.getDataLocation()));
        }
    }

    public HiveCopyEntityHelper getHiveCopyEntityHelper() {
        return this.hiveCopyEntityHelper;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<Partition> getExistingTargetPartition() {
        return this.existingTargetPartition;
    }

    public EventSubmitter getEventSubmitter() {
        return this.eventSubmitter;
    }
}

