/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.entities;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.hive.ql.metadata.Table;

public class StageableTableMetadata {
    public static final String DESTINATION_TABLE_KEY = "destination.tableName";
    public static final String DESTINATION_DB_KEY = "destination.dbName";
    public static final String DESTINATION_DATA_PATH_KEY = "destination.dataPath";
    public static final String DESTINATION_TABLE_PROPERTIES_LIST_KEY = "destination.tableProperties";
    public static final String CLUSTER_BY_KEY = "clusterByList";
    public static final String NUM_BUCKETS_KEY = "numBuckets";
    public static final String EVOLUTION_ENABLED = "evolution.enabled";
    public static final String ROW_LIMIT_KEY = "rowLimit";
    public static final String HIVE_VERSION_KEY = "hiveVersion";
    public static final String HIVE_RUNTIME_PROPERTIES_LIST_KEY = "hiveRuntimeProperties";
    public static final String SOURCE_DATA_PATH_IDENTIFIER_KEY = "source.dataPathIdentifier";
    private final String destinationTableName;
    private final String destinationStagingTableName;
    private final String destinationDbName;
    private final String destinationDataPath;
    private final Properties destinationTableProperties;
    private final List<String> clusterBy;
    private final Optional<Integer> numBuckets;
    private final Properties hiveRuntimeProperties;
    private final boolean evolutionEnabled;
    private final Optional<Integer> rowLimit;
    private final List<String> sourceDataPathIdentifier;

    public StageableTableMetadata(Config config, @Nullable Table referenceTable) {
        Preconditions.checkArgument((boolean)config.hasPath(DESTINATION_TABLE_KEY), (Object)String.format("Key %s is not specified", DESTINATION_TABLE_KEY));
        Preconditions.checkArgument((boolean)config.hasPath(DESTINATION_DB_KEY), (Object)String.format("Key %s is not specified", DESTINATION_DB_KEY));
        Preconditions.checkArgument((boolean)config.hasPath(DESTINATION_DATA_PATH_KEY), (Object)String.format("Key %s is not specified", DESTINATION_DATA_PATH_KEY));
        this.destinationTableName = referenceTable == null ? config.getString(DESTINATION_TABLE_KEY) : HiveDataset.resolveTemplate(config.getString(DESTINATION_TABLE_KEY), referenceTable);
        this.destinationStagingTableName = String.format("%s_%s", this.destinationTableName, "staging");
        this.destinationDbName = referenceTable == null ? config.getString(DESTINATION_DB_KEY) : HiveDataset.resolveTemplate(config.getString(DESTINATION_DB_KEY), referenceTable);
        this.destinationDataPath = referenceTable == null ? config.getString(DESTINATION_DATA_PATH_KEY) : HiveDataset.resolveTemplate(config.getString(DESTINATION_DATA_PATH_KEY), referenceTable);
        this.destinationTableProperties = this.convertKeyValueListToProperties(ConfigUtils.getStringList((Config)config, (String)DESTINATION_TABLE_PROPERTIES_LIST_KEY));
        this.clusterBy = ConfigUtils.getStringList((Config)config, (String)CLUSTER_BY_KEY);
        this.numBuckets = Optional.fromNullable((Object)ConfigUtils.getInt((Config)config, (String)NUM_BUCKETS_KEY, null));
        this.hiveRuntimeProperties = this.convertKeyValueListToProperties(ConfigUtils.getStringList((Config)config, (String)HIVE_RUNTIME_PROPERTIES_LIST_KEY));
        this.evolutionEnabled = ConfigUtils.getBoolean((Config)config, (String)EVOLUTION_ENABLED, (boolean)false);
        this.rowLimit = Optional.fromNullable((Object)ConfigUtils.getInt((Config)config, (String)ROW_LIMIT_KEY, null));
        this.sourceDataPathIdentifier = ConfigUtils.getStringList((Config)config, (String)SOURCE_DATA_PATH_IDENTIFIER_KEY);
    }

    private Properties convertKeyValueListToProperties(List<String> keyValueList) {
        Preconditions.checkArgument((keyValueList.size() % 2 == 0 ? 1 : 0) != 0, (Object)String.format("The list %s does not have equal number of keys and values. Size %s", keyValueList, keyValueList.size()));
        Properties props = new Properties();
        for (int i = 0; i < keyValueList.size(); i += 2) {
            String key = keyValueList.get(i);
            String value = keyValueList.get(i + 1);
            props.put(key, value);
        }
        return props;
    }

    public String getDestinationTableName() {
        return this.destinationTableName;
    }

    public String getDestinationStagingTableName() {
        return this.destinationStagingTableName;
    }

    public String getDestinationDbName() {
        return this.destinationDbName;
    }

    public String getDestinationDataPath() {
        return this.destinationDataPath;
    }

    public Properties getDestinationTableProperties() {
        return this.destinationTableProperties;
    }

    public List<String> getClusterBy() {
        return this.clusterBy;
    }

    public Optional<Integer> getNumBuckets() {
        return this.numBuckets;
    }

    public Properties getHiveRuntimeProperties() {
        return this.hiveRuntimeProperties;
    }

    public boolean isEvolutionEnabled() {
        return this.evolutionEnabled;
    }

    public Optional<Integer> getRowLimit() {
        return this.rowLimit;
    }

    public List<String> getSourceDataPathIdentifier() {
        return this.sourceDataPathIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StageableTableMetadata)) {
            return false;
        }
        StageableTableMetadata other = (StageableTableMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$destinationTableName = this.getDestinationTableName();
        String other$destinationTableName = other.getDestinationTableName();
        if (this$destinationTableName == null ? other$destinationTableName != null : !this$destinationTableName.equals(other$destinationTableName)) {
            return false;
        }
        String this$destinationStagingTableName = this.getDestinationStagingTableName();
        String other$destinationStagingTableName = other.getDestinationStagingTableName();
        if (this$destinationStagingTableName == null ? other$destinationStagingTableName != null : !this$destinationStagingTableName.equals(other$destinationStagingTableName)) {
            return false;
        }
        String this$destinationDbName = this.getDestinationDbName();
        String other$destinationDbName = other.getDestinationDbName();
        if (this$destinationDbName == null ? other$destinationDbName != null : !this$destinationDbName.equals(other$destinationDbName)) {
            return false;
        }
        String this$destinationDataPath = this.getDestinationDataPath();
        String other$destinationDataPath = other.getDestinationDataPath();
        if (this$destinationDataPath == null ? other$destinationDataPath != null : !this$destinationDataPath.equals(other$destinationDataPath)) {
            return false;
        }
        Properties this$destinationTableProperties = this.getDestinationTableProperties();
        Properties other$destinationTableProperties = other.getDestinationTableProperties();
        if (this$destinationTableProperties == null ? other$destinationTableProperties != null : !((Object)this$destinationTableProperties).equals(other$destinationTableProperties)) {
            return false;
        }
        List<String> this$clusterBy = this.getClusterBy();
        List<String> other$clusterBy = other.getClusterBy();
        if (this$clusterBy == null ? other$clusterBy != null : !((Object)this$clusterBy).equals(other$clusterBy)) {
            return false;
        }
        Optional<Integer> this$numBuckets = this.getNumBuckets();
        Optional<Integer> other$numBuckets = other.getNumBuckets();
        if (this$numBuckets == null ? other$numBuckets != null : !this$numBuckets.equals(other$numBuckets)) {
            return false;
        }
        Properties this$hiveRuntimeProperties = this.getHiveRuntimeProperties();
        Properties other$hiveRuntimeProperties = other.getHiveRuntimeProperties();
        if (this$hiveRuntimeProperties == null ? other$hiveRuntimeProperties != null : !((Object)this$hiveRuntimeProperties).equals(other$hiveRuntimeProperties)) {
            return false;
        }
        if (this.isEvolutionEnabled() != other.isEvolutionEnabled()) {
            return false;
        }
        Optional<Integer> this$rowLimit = this.getRowLimit();
        Optional<Integer> other$rowLimit = other.getRowLimit();
        if (this$rowLimit == null ? other$rowLimit != null : !this$rowLimit.equals(other$rowLimit)) {
            return false;
        }
        List<String> this$sourceDataPathIdentifier = this.getSourceDataPathIdentifier();
        List<String> other$sourceDataPathIdentifier = other.getSourceDataPathIdentifier();
        return !(this$sourceDataPathIdentifier == null ? other$sourceDataPathIdentifier != null : !((Object)this$sourceDataPathIdentifier).equals(other$sourceDataPathIdentifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StageableTableMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $destinationTableName = this.getDestinationTableName();
        result = result * 59 + ($destinationTableName == null ? 43 : $destinationTableName.hashCode());
        String $destinationStagingTableName = this.getDestinationStagingTableName();
        result = result * 59 + ($destinationStagingTableName == null ? 43 : $destinationStagingTableName.hashCode());
        String $destinationDbName = this.getDestinationDbName();
        result = result * 59 + ($destinationDbName == null ? 43 : $destinationDbName.hashCode());
        String $destinationDataPath = this.getDestinationDataPath();
        result = result * 59 + ($destinationDataPath == null ? 43 : $destinationDataPath.hashCode());
        Properties $destinationTableProperties = this.getDestinationTableProperties();
        result = result * 59 + ($destinationTableProperties == null ? 43 : ((Object)$destinationTableProperties).hashCode());
        List<String> $clusterBy = this.getClusterBy();
        result = result * 59 + ($clusterBy == null ? 43 : ((Object)$clusterBy).hashCode());
        Optional<Integer> $numBuckets = this.getNumBuckets();
        result = result * 59 + ($numBuckets == null ? 43 : $numBuckets.hashCode());
        Properties $hiveRuntimeProperties = this.getHiveRuntimeProperties();
        result = result * 59 + ($hiveRuntimeProperties == null ? 43 : ((Object)$hiveRuntimeProperties).hashCode());
        result = result * 59 + (this.isEvolutionEnabled() ? 79 : 97);
        Optional<Integer> $rowLimit = this.getRowLimit();
        result = result * 59 + ($rowLimit == null ? 43 : $rowLimit.hashCode());
        List<String> $sourceDataPathIdentifier = this.getSourceDataPathIdentifier();
        result = result * 59 + ($sourceDataPathIdentifier == null ? 43 : ((Object)$sourceDataPathIdentifier).hashCode());
        return result;
    }

    public String toString() {
        return "StageableTableMetadata(destinationTableName=" + this.getDestinationTableName() + ", destinationStagingTableName=" + this.getDestinationStagingTableName() + ", destinationDbName=" + this.getDestinationDbName() + ", destinationDataPath=" + this.getDestinationDataPath() + ", destinationTableProperties=" + this.getDestinationTableProperties() + ", clusterBy=" + this.getClusterBy() + ", numBuckets=" + this.getNumBuckets() + ", hiveRuntimeProperties=" + this.getHiveRuntimeProperties() + ", evolutionEnabled=" + this.isEvolutionEnabled() + ", rowLimit=" + this.getRowLimit() + ", sourceDataPathIdentifier=" + this.getSourceDataPathIdentifier() + ")";
    }

    @ConstructorProperties(value={"destinationTableName", "destinationStagingTableName", "destinationDbName", "destinationDataPath", "destinationTableProperties", "clusterBy", "numBuckets", "hiveRuntimeProperties", "evolutionEnabled", "rowLimit", "sourceDataPathIdentifier"})
    public StageableTableMetadata(String destinationTableName, String destinationStagingTableName, String destinationDbName, String destinationDataPath, Properties destinationTableProperties, List<String> clusterBy, Optional<Integer> numBuckets, Properties hiveRuntimeProperties, boolean evolutionEnabled, Optional<Integer> rowLimit, List<String> sourceDataPathIdentifier) {
        this.destinationTableName = destinationTableName;
        this.destinationStagingTableName = destinationStagingTableName;
        this.destinationDbName = destinationDbName;
        this.destinationDataPath = destinationDataPath;
        this.destinationTableProperties = destinationTableProperties;
        this.clusterBy = clusterBy;
        this.numBuckets = numBuckets;
        this.hiveRuntimeProperties = hiveRuntimeProperties;
        this.evolutionEnabled = evolutionEnabled;
        this.rowLimit = rowLimit;
        this.sourceDataPathIdentifier = sourceDataPathIdentifier;
    }
}

