/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.snapshot.gen;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.IdentifierSchema;
import com.linkedin.restli.restspec.MetadataSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnapshotGenerator {
    private ResourceSchema _topLevelSchema;
    private DataSchemaResolver _schemaResolver;

    public SnapshotGenerator(ResourceSchema resourceSchema, DataSchemaResolver schemaResolver) {
        this._topLevelSchema = resourceSchema;
        this._schemaResolver = schemaResolver;
    }

    public List<NamedDataSchema> generateModelList() {
        ArrayList<NamedDataSchema> result = new ArrayList<NamedDataSchema>();
        HashMap<String, NamedDataSchema> map = new HashMap<String, NamedDataSchema>();
        this.findModelsResource(this._topLevelSchema, map, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeFile(File outdirFile, String fileName) throws IOException {
        fileName = fileName + ".snapshot.json";
        File file = new File(outdirFile, fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JsonBuilder jsonBuilder = new JsonBuilder(JsonBuilder.Pretty.INDENTED);
        SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(jsonBuilder);
        jsonBuilder.writeStartObject();
        jsonBuilder.writeFieldName("models");
        jsonBuilder.writeStartArray();
        List<NamedDataSchema> models = this.generateModelList();
        for (DataSchema dataSchema : models) {
            encoder.encode(dataSchema);
        }
        jsonBuilder.writeEndArray();
        jsonBuilder.writeFieldName("schema");
        jsonBuilder.writeDataTemplate((DataTemplate)this._topLevelSchema, Boolean.valueOf(true));
        jsonBuilder.writeEndObject();
        try {
            fileOutputStream.write(jsonBuilder.result().getBytes());
        }
        finally {
            fileOutputStream.close();
            jsonBuilder.close();
        }
        return file;
    }

    private void findModelsResource(ResourceSchema resourceSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        String schema = resourceSchema.getSchema();
        if (schema != null) {
            this.recordType(schema, foundTypes, typeOrder);
        }
        this.findModelsActionSet(resourceSchema, foundTypes, typeOrder);
        this.findModelsAssocation(resourceSchema, foundTypes, typeOrder);
        this.findModelsCollection(resourceSchema, foundTypes, typeOrder);
        this.findModelsSimple(resourceSchema, foundTypes, typeOrder);
    }

    private void findModelsCollection(ResourceSchema resourceSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        CollectionSchema collection = resourceSchema.getCollection();
        if (collection != null) {
            IdentifierSchema identifier = collection.getIdentifier();
            this.findModelsIdentifier(identifier, foundTypes, typeOrder);
            if (collection.hasFinders()) {
                for (FinderSchema restMethodSchema : collection.getFinders()) {
                    this.findModelsFinder(restMethodSchema, foundTypes, typeOrder);
                }
            }
            if (collection.hasMethods()) {
                for (FinderSchema restMethodSchema : collection.getMethods()) {
                    this.findModelsMethod((RestMethodSchema)restMethodSchema, foundTypes, typeOrder);
                }
            }
            if (collection.hasActions()) {
                for (ActionSchema actionSchema : collection.getActions()) {
                    this.findModelsAction(actionSchema, foundTypes, typeOrder);
                }
            }
            if (collection.hasEntity()) {
                EntitySchema entity = collection.getEntity();
                this.findModelsEntity(entity, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsEntity(EntitySchema entity, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        if (entity.hasActions()) {
            for (ActionSchema actionSchema : entity.getActions()) {
                this.findModelsAction(actionSchema, foundTypes, typeOrder);
            }
        }
        if (entity.hasSubresources()) {
            for (ResourceSchema subresourceSchema : entity.getSubresources()) {
                this.findModelsResource(subresourceSchema, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsIdentifier(IdentifierSchema identifier, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        String identifierType = identifier.getType();
        this.recordType(identifierType, foundTypes, typeOrder);
        String paramsType = identifier.getParams();
        if (paramsType != null) {
            this.recordType(paramsType, foundTypes, typeOrder);
        }
    }

    private void findModelsAssocation(ResourceSchema resourceSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        AssociationSchema association = resourceSchema.getAssociation();
        if (association != null) {
            for (AssocKeySchema assocKeySchema : association.getAssocKeys()) {
                String type = assocKeySchema.getType();
                this.recordType(type, foundTypes, typeOrder);
            }
            if (association.hasFinders()) {
                for (FinderSchema restMethodSchema : association.getFinders()) {
                    this.findModelsFinder(restMethodSchema, foundTypes, typeOrder);
                }
            }
            if (association.hasMethods()) {
                for (FinderSchema restMethodSchema : association.getMethods()) {
                    this.findModelsMethod((RestMethodSchema)restMethodSchema, foundTypes, typeOrder);
                }
            }
            if (association.hasActions()) {
                for (ActionSchema actionSchema : association.getActions()) {
                    this.findModelsAction(actionSchema, foundTypes, typeOrder);
                }
            }
            if (association.hasEntity()) {
                EntitySchema entitySchema = association.getEntity();
                this.findModelsEntity(entitySchema, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsSimple(ResourceSchema resourceSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        SimpleSchema simple = resourceSchema.getSimple();
        if (simple != null) {
            if (simple.hasMethods()) {
                for (RestMethodSchema restMethodSchema : simple.getMethods()) {
                    this.findModelsMethod(restMethodSchema, foundTypes, typeOrder);
                }
            }
            if (simple.hasActions()) {
                for (ActionSchema actionSchema : simple.getActions()) {
                    this.findModelsAction(actionSchema, foundTypes, typeOrder);
                }
            }
            if (simple.hasEntity()) {
                EntitySchema entity = simple.getEntity();
                this.findModelsEntity(entity, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsActionSet(ResourceSchema resourceSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        ActionsSetSchema actionsSet = resourceSchema.getActionsSet();
        if (actionsSet != null && actionsSet.hasActions()) {
            for (ActionSchema actionSchema : actionsSet.getActions()) {
                this.findModelsAction(actionSchema, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsAction(ActionSchema actionSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        String returns;
        if (actionSchema.hasParameters()) {
            for (ParameterSchema parameterSchema : actionSchema.getParameters()) {
                this.findModelsParameter(parameterSchema, foundTypes, typeOrder);
            }
        }
        if ((returns = actionSchema.getReturns()) != null) {
            this.recordType(returns, foundTypes, typeOrder);
        }
    }

    private void findModelsFinder(FinderSchema finderSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        MetadataSchema metadata;
        ParameterSchemaArray parameters = finderSchema.getParameters();
        if (parameters != null) {
            for (ParameterSchema parameterSchema : parameters) {
                this.findModelsParameter(parameterSchema, foundTypes, typeOrder);
            }
        }
        if ((metadata = finderSchema.getMetadata()) != null) {
            String type = metadata.getType();
            this.recordType(type, foundTypes, typeOrder);
        }
    }

    private void findModelsMethod(RestMethodSchema restMethodSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        ParameterSchemaArray parameters = restMethodSchema.getParameters();
        if (parameters != null) {
            for (ParameterSchema parameterSchema : parameters) {
                this.findModelsParameter(parameterSchema, foundTypes, typeOrder);
            }
        }
    }

    private void findModelsParameter(ParameterSchema parameterSchema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        String type = parameterSchema.getType();
        if (type.equals("array") || type.equals("map")) {
            String items = parameterSchema.getItems();
            this.recordType(items, foundTypes, typeOrder);
        } else {
            this.recordType(type, foundTypes, typeOrder);
        }
    }

    private void recordType(String type, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        if (!foundTypes.containsKey(type)) {
            DataSchema schema = RestSpecCodec.textToSchema((String)type, (DataSchemaResolver)this._schemaResolver);
            this.recordType(schema, foundTypes, typeOrder);
        }
    }

    private void recordType(DataSchema schema, Map<String, NamedDataSchema> foundTypes, List<NamedDataSchema> typeOrder) {
        if (schema instanceof NamedDataSchema) {
            NamedDataSchema namedDataSchema = (NamedDataSchema)schema;
            if (!foundTypes.containsKey(namedDataSchema.getFullName())) {
                foundTypes.put(namedDataSchema.getFullName(), namedDataSchema);
                if (schema instanceof RecordDataSchema) {
                    RecordDataSchema recordDataSchema = (RecordDataSchema)schema;
                    for (NamedDataSchema includedSchema : recordDataSchema.getInclude()) {
                        this.recordType((DataSchema)includedSchema, foundTypes, typeOrder);
                    }
                    for (RecordDataSchema.Field field : recordDataSchema.getFields()) {
                        this.recordType(field.getType(), foundTypes, typeOrder);
                    }
                } else if (schema instanceof TyperefDataSchema) {
                    this.recordType(schema.getDereferencedDataSchema(), foundTypes, typeOrder);
                }
                typeOrder.add(namedDataSchema);
            }
        } else if (schema instanceof ArrayDataSchema) {
            ArrayDataSchema arraySchema = (ArrayDataSchema)schema;
            this.recordType(arraySchema.getItems(), foundTypes, typeOrder);
        } else if (schema instanceof MapDataSchema) {
            MapDataSchema mapSchema = (MapDataSchema)schema;
            this.recordType(mapSchema.getValues(), foundTypes, typeOrder);
        } else if (schema instanceof UnionDataSchema) {
            UnionDataSchema unionSchema = (UnionDataSchema)schema;
            for (DataSchema type : unionSchema.getTypes()) {
                this.recordType(type, foundTypes, typeOrder);
            }
        }
    }
}

