/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.idlgen;

import com.linkedin.restli.internal.server.model.ResourceModelEncoder;
import com.linkedin.restli.tools.idlgen.RestLiDoclet;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocletDocsProvider
implements ResourceModelEncoder.DocsProvider {
    private static final Logger log = LoggerFactory.getLogger(DocletDocsProvider.class);
    private final String _apiName;
    private final String[] _classpath;
    private final String[] _sourcePaths;
    private final String[] _resourcePackages;
    private RestLiDoclet _doclet;

    public DocletDocsProvider(String apiName, String[] classpath, String[] sourcePaths, String[] resourcePackages) {
        this._apiName = apiName;
        this._classpath = classpath;
        this._sourcePaths = sourcePaths;
        this._resourcePackages = resourcePackages;
    }

    public Set<String> supportedFileExtensions() {
        return Collections.singleton(".java");
    }

    public void registerSourceFiles(Collection<String> sourceFileNames) {
        log.info("Executing Javadoc tool...");
        String flatClasspath = this._classpath == null ? System.getProperty("java.class.path") : StringUtils.join((Object[])this._classpath, (String)":");
        PrintWriter sysoutWriter = new PrintWriter(System.out, true);
        PrintWriter nullWriter = new PrintWriter((Writer)new NullWriter());
        ArrayList<String> javadocArgs = new ArrayList<String>(Arrays.asList("-classpath", flatClasspath, "-sourcepath", StringUtils.join((Object[])this._sourcePaths, (String)":")));
        if (this._resourcePackages != null) {
            javadocArgs.add("-subpackages");
            javadocArgs.add(StringUtils.join((Object[])this._resourcePackages, (String)":"));
        } else {
            javadocArgs.addAll(sourceFileNames);
        }
        this._doclet = RestLiDoclet.generateDoclet(this._apiName, sysoutWriter, nullWriter, nullWriter, javadocArgs.toArray(new String[0]));
    }

    public String getClassDoc(Class<?> resourceClass) {
        ClassDoc doc = this._doclet.getClassDoc(resourceClass);
        if (doc == null) {
            return null;
        }
        return this.buildDoc(doc.commentText());
    }

    public String getClassDeprecatedTag(Class<?> resourceClass) {
        ClassDoc doc = this._doclet.getClassDoc(resourceClass);
        if (doc == null) {
            return null;
        }
        return this.formatDeprecatedTags((Doc)doc);
    }

    private String formatDeprecatedTags(Doc doc) {
        Tag[] deprecatedTags = doc.tags("deprecated");
        if (deprecatedTags.length > 0) {
            StringBuilder deprecatedText = new StringBuilder();
            for (int i = 0; i < deprecatedTags.length; ++i) {
                deprecatedText.append(deprecatedTags[i].text());
                if (i >= deprecatedTags.length - 1) continue;
                deprecatedText.append(" ");
            }
            return deprecatedText.toString();
        }
        return null;
    }

    public String getMethodDoc(Method method) {
        MethodDoc doc = this._doclet.getMethodDoc(method);
        if (doc == null) {
            return null;
        }
        return this.buildDoc(doc.commentText());
    }

    public String getMethodDeprecatedTag(Method method) {
        MethodDoc doc = this._doclet.getMethodDoc(method);
        if (doc == null) {
            return null;
        }
        return this.formatDeprecatedTags((Doc)doc);
    }

    public String getParamDoc(Method method, String name) {
        MethodDoc methodDoc = this._doclet.getMethodDoc(method);
        if (methodDoc != null) {
            for (ParamTag tag : methodDoc.paramTags()) {
                if (!name.equals(tag.parameterName())) continue;
                return this.buildDoc(tag.parameterComment());
            }
        }
        return null;
    }

    public String getReturnDoc(Method method) {
        MethodDoc methodDoc = this._doclet.getMethodDoc(method);
        if (methodDoc != null) {
            for (Tag tag : methodDoc.tags()) {
                if (!tag.name().toLowerCase().equals("@return")) continue;
                return this.buildDoc(tag.text());
            }
        }
        return null;
    }

    private String buildDoc(String docText) {
        if (docText != null && !docText.isEmpty()) {
            return docText;
        }
        return null;
    }
}

