/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.data;

import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.Predicates;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

public class PredicateExpressionParser {
    private static final String OPERATORS = "()!&|";
    private static final Map<Character, Integer> OPERATOR_PRECEDENCE = new HashMap<Character, Integer>();

    public static Predicate parse(String expression) {
        Stack<Predicate> predicateStack = new Stack<Predicate>();
        Stack<Character> operatorStack = new Stack<Character>();
        String trimmedExpression = expression.replaceAll("\\s", "");
        StringTokenizer tokenizer = new StringTokenizer(trimmedExpression, OPERATORS, true);
        boolean isTokenMode = true;
        while (true) {
            Character operator;
            String token;
            if (isTokenMode) {
                if (!tokenizer.hasMoreTokens()) break;
                token = tokenizer.nextToken();
                operator = OPERATORS.contains(token) ? Character.valueOf(token.charAt(0)) : null;
            } else {
                operator = (Character)operatorStack.pop();
                token = null;
            }
            isTokenMode = true;
            if (operator == null) {
                try {
                    predicateStack.push(Class.forName(token).asSubclass(Predicate.class).newInstance());
                }
                catch (ClassCastException e) {
                    throw new RuntimeException(token + " must implement " + Predicate.class.getName(), e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (operatorStack.empty() || operator.charValue() == '(') {
                operatorStack.push(operator);
                continue;
            }
            if (operator.charValue() == ')') {
                while (operatorStack.peek().charValue() != '(') {
                    PredicateExpressionParser.evaluate(predicateStack, operatorStack);
                }
                operatorStack.pop();
                continue;
            }
            if (OPERATOR_PRECEDENCE.get(operator) < OPERATOR_PRECEDENCE.get(operatorStack.peek())) {
                PredicateExpressionParser.evaluate(predicateStack, operatorStack);
                isTokenMode = false;
            }
            operatorStack.push(operator);
        }
        while (!operatorStack.empty()) {
            PredicateExpressionParser.evaluate(predicateStack, operatorStack);
        }
        if (predicateStack.size() > 1) {
            throw new RuntimeException("Invalid logical expression");
        }
        return predicateStack.pop();
    }

    private static void evaluate(Stack<Predicate> predicateStack, Stack<Character> operatorStack) {
        Predicate evaluatedPredicate;
        char operator = operatorStack.pop().charValue();
        switch (operator) {
            case '&': 
            case '|': {
                evaluatedPredicate = PredicateExpressionParser.evaluateMultiaryOperator(predicateStack, operatorStack, operator);
                break;
            }
            case '!': {
                evaluatedPredicate = Predicates.not((Predicate)predicateStack.pop());
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator: " + operator);
            }
        }
        predicateStack.push(evaluatedPredicate);
    }

    private static Predicate evaluateMultiaryOperator(Stack<Predicate> predicateStack, Stack<Character> operatorStack, char operator) {
        ArrayDeque<Predicate> predicateOperands = new ArrayDeque<Predicate>();
        predicateOperands.addFirst(predicateStack.pop());
        predicateOperands.addFirst(predicateStack.pop());
        while (!operatorStack.empty() && operator == operatorStack.peek().charValue()) {
            predicateOperands.addFirst(predicateStack.pop());
            operatorStack.pop();
        }
        switch (operator) {
            case '&': {
                return Predicates.and(predicateOperands);
            }
            case '|': {
                return Predicates.or(predicateOperands);
            }
        }
        throw new RuntimeException("Logic error");
    }

    static {
        OPERATOR_PRECEDENCE.put(Character.valueOf('('), 0);
        OPERATOR_PRECEDENCE.put(Character.valueOf('|'), 1);
        OPERATOR_PRECEDENCE.put(Character.valueOf('&'), 2);
        OPERATOR_PRECEDENCE.put(Character.valueOf('!'), 3);
        OPERATOR_PRECEDENCE.put(Character.valueOf(')'), 4);
    }
}

