/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.clientgen;

import com.linkedin.common.Version;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.DefaultGeneratorResult;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.PegasusDataTemplateGenerator;
import com.linkedin.restli.internal.common.RestliVersion;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.tools.clientgen.JavaRequestBuilderGenerator;
import com.linkedin.restli.tools.clientgen.RestSpecParser;
import com.linkedin.util.FileUtil;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestBuilderGenerator {
    private static final String GENERATOR_REST_GENERATE_DATATEMPLATES = "generator.rest.generate.datatemplates";
    private static final String GENERATOR_REST_GENERATE_VERSION = "generator.rest.generate.version";
    private static final String GENERATOR_REST_GENERATE_DEPRECATED_VERSION = "generator.rest.generate.deprecated.version";
    private static final Logger _log = LoggerFactory.getLogger(RestRequestBuilderGenerator.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            _log.error("Usage: RestRequestBuilderGenerator targetDirectoryPath [sourceFile or sourceDirectory]+");
            System.exit(1);
        }
        String generateImported = System.getProperty("generator.generate.imported");
        String generateDataTemplates = System.getProperty(GENERATOR_REST_GENERATE_DATATEMPLATES);
        String versionString = System.getProperty(GENERATOR_REST_GENERATE_VERSION);
        RestliVersion version = RestliVersion.lookUpRestliVersion((Version)new Version(versionString));
        if (version == null) {
            throw new IllegalArgumentException("Unrecognized version: " + versionString);
        }
        RestliVersion deprecatedByVersion = RestRequestBuilderGenerator.findDeprecatedVersion();
        RestRequestBuilderGenerator.run(System.getProperty("generator.resolver.path"), System.getProperty("generator.default.package"), generateImported == null ? true : Boolean.parseBoolean(generateImported), generateDataTemplates == null ? true : Boolean.parseBoolean(generateDataTemplates), version, deprecatedByVersion, args[0], Arrays.copyOfRange(args, 1, args.length));
    }

    public static RestliVersion findDeprecatedVersion() {
        String deprecatedByVersionString = System.getProperty(GENERATOR_REST_GENERATE_DEPRECATED_VERSION);
        if (deprecatedByVersionString == null) {
            return null;
        }
        try {
            return RestliVersion.lookUpRestliVersion((Version)new Version(deprecatedByVersionString));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static GeneratorResult run(String resolverPath, String defaultPackage, boolean generateImported, final boolean generateDataTemplates, RestliVersion version, RestliVersion deprecatedByVersion, String targetDirectoryPath, String[] sources) throws IOException {
        List modifiedFiles;
        RestSpecParser parser = new RestSpecParser();
        final JavaRequestBuilderGenerator generator = new JavaRequestBuilderGenerator(resolverPath, defaultPackage, generateDataTemplates, version, deprecatedByVersion);
        final ClassLoader classLoader = JavaCodeUtil.classLoaderFromResolverPath((String)resolverPath);
        RestSpecParser.ParseResult parseResult = parser.parseSources(sources);
        StringBuilder message = new StringBuilder();
        for (CodeUtil.Pair<ResourceSchema, File> pair : parseResult.getSchemaAndFiles()) {
            try {
                JDefinedClass jDefinedClass = generator.generate((ResourceSchema)pair.first, (File)pair.second);
            }
            catch (Exception e) {
                message.append(e.getMessage() + "\n");
            }
        }
        if (message.length() > 0) {
            throw new IOException(message.toString());
        }
        final PegasusDataTemplateGenerator.DataTemplatePersistentClassChecker dataTemplateChecker = new PegasusDataTemplateGenerator.DataTemplatePersistentClassChecker(generateImported, generator.getSpecGenerator(), generator.getJavaDataTemplateGenerator(), Collections.emptySet());
        JavaCodeUtil.PersistentClassChecker checker = new JavaCodeUtil.PersistentClassChecker(){

            public boolean isPersistent(JDefinedClass clazz) {
                if (generateDataTemplates || generator.isGeneratedArrayClass((JClass)clazz)) {
                    try {
                        Class.forName(clazz.fullName(), false, classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return true;
                    }
                }
                return dataTemplateChecker.isPersistent(clazz);
            }
        };
        JCodeModel requestBuilderCodeModel = generator.getCodeModel();
        JCodeModel dataTemplateCodeModel = generator.getJavaDataTemplateGenerator().getCodeModel();
        File targetDirectory = new File(targetDirectoryPath);
        List targetFiles = JavaCodeUtil.targetFiles((File)targetDirectory, (JCodeModel)requestBuilderCodeModel, (ClassLoader)classLoader, (JavaCodeUtil.PersistentClassChecker)checker);
        targetFiles.addAll(JavaCodeUtil.targetFiles((File)targetDirectory, (JCodeModel)dataTemplateCodeModel, (ClassLoader)classLoader, (JavaCodeUtil.PersistentClassChecker)checker));
        if (FileUtil.upToDate(parseResult.getSourceFiles(), (Collection)targetFiles)) {
            modifiedFiles = Collections.emptyList();
            _log.info("Target files are up-to-date: " + targetFiles);
        } else {
            modifiedFiles = targetFiles;
            _log.info("Generating " + targetFiles.size() + " files: " + targetFiles);
            requestBuilderCodeModel.build((CodeWriter)new FileCodeWriter(targetDirectory, true));
            dataTemplateCodeModel.build((CodeWriter)new FileCodeWriter(targetDirectory, true));
        }
        return new DefaultGeneratorResult(parseResult.getSourceFiles(), (Collection)targetFiles, (Collection)modifiedFiles);
    }
}

