/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.restli;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.restli.client.RestClient;
import com.typesafe.config.Config;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.gobblin.broker.ResourceCoordinate;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.restli.SharedRestClientKey;
import org.apache.gobblin.restli.UriRestClientKey;
import org.apache.gobblin.util.ExecutorsUtils;

public class SharedRestClientFactory<S extends ScopeType<S>>
implements SharedResourceFactory<RestClient, SharedRestClientKey, S> {
    public static final String FACTORY_NAME = "restli";
    public static final String SERVER_URI_KEY = "serverUri";
    private static final Set<String> RESTLI_SCHEMES = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public String getName() {
        return FACTORY_NAME;
    }

    public SharedResourceFactoryResponse<RestClient> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, SharedRestClientKey> config) throws NotConfiguredException {
        try {
            SharedRestClientKey key = (SharedRestClientKey)config.getKey();
            if (!(key instanceof UriRestClientKey)) {
                return new ResourceCoordinate((SharedResourceFactory)this, (SharedResourceKey)new UriRestClientKey(key.serviceName, SharedRestClientFactory.resolveUriPrefix(config.getConfig(), key)), config.getScope());
            }
            String uriPrefix = ((UriRestClientKey)key).getUri();
            HttpClientFactory http = new HttpClientFactory(FilterChains.empty(), new NioEventLoopGroup(0, ExecutorsUtils.newDaemonThreadFactory((Optional)Optional.absent(), (Optional)Optional.of((Object)"R2 Nio Event Loop-%d"))), true, Executors.newSingleThreadScheduledExecutor(ExecutorsUtils.newDaemonThreadFactory((Optional)Optional.absent(), (Optional)Optional.of((Object)"R2 Netty Scheduler"))), true);
            TransportClientAdapter r2Client = new TransportClientAdapter(http.getClient(Collections.emptyMap()));
            return new ResourceInstance((Object)new RestClient((Client)r2Client, uriPrefix));
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Could not create a rest client for key " + (String)Optional.fromNullable((Object)((SharedRestClientKey)config.getKey()).toConfigurationKey()).or((Object)"null"));
        }
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, SharedRestClientKey> config) {
        return (S)broker.selfScope().getType().rootScope();
    }

    public static String resolveUriPrefix(Config config, SharedRestClientKey key) throws URISyntaxException, NotConfiguredException {
        List<String> connectionPrefixes = SharedRestClientFactory.parseConnectionPrefixes(config, key);
        Preconditions.checkArgument((connectionPrefixes.size() > 0 ? 1 : 0) != 0, (Object)("No uris found for service " + key.serviceName));
        return connectionPrefixes.get(new Random().nextInt(connectionPrefixes.size()));
    }

    public static List<String> parseConnectionPrefixes(Config config, SharedRestClientKey key) throws URISyntaxException, NotConfiguredException {
        if (key instanceof UriRestClientKey) {
            return Lists.newArrayList((Object[])new String[]{((UriRestClientKey)key).getUri()});
        }
        if (!config.hasPath(SERVER_URI_KEY)) {
            throw new NotConfiguredException("Missing key serverUri");
        }
        ArrayList uris = Lists.newArrayList();
        for (String uri : Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)config.getString(SERVER_URI_KEY))) {
            uris.add(SharedRestClientFactory.resolveUriPrefix(new URI(uri)));
        }
        return uris;
    }

    public static String resolveUriPrefix(URI serverURI) throws URISyntaxException {
        if (RESTLI_SCHEMES.contains(serverURI.getScheme())) {
            return new URI(serverURI.getScheme(), serverURI.getAuthority(), null, null, null).toString() + "/";
        }
        throw new RuntimeException("Unrecognized scheme for URI " + serverURI);
    }
}

