/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        SdkInternalList tagsList;
        if (deleteTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTagsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList resourcesList = (SdkInternalList)deleteTagsRequest.getResources();
        if (!resourcesList.isEmpty() || !resourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String resourcesListValue : resourcesList) {
                if (resourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString((String)resourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)deleteTagsRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

