/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.utils;

import com.google.common.annotations.VisibleForTesting;
import org.apache.gobblin.annotation.Alpha;
import org.apache.helix.Criteria;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.Message;
import org.apache.helix.tools.ClusterSetup;
import org.slf4j.Logger;

@Alpha
public class HelixUtils {
    public static HelixManager buildHelixManager(String helixInstanceName, String helixClusterName, String zkConnectionString) {
        return HelixManagerFactory.getZKHelixManager((String)helixClusterName, (String)helixInstanceName, (InstanceType)InstanceType.CONTROLLER, (String)zkConnectionString);
    }

    public static void createGobblinHelixCluster(String zkConnectionString, String clusterName) {
        HelixUtils.createGobblinHelixCluster(zkConnectionString, clusterName, true);
    }

    public static void createGobblinHelixCluster(String zkConnectionString, String clusterName, boolean overwrite) {
        ClusterSetup clusterSetup = new ClusterSetup(zkConnectionString);
        clusterSetup.addCluster(clusterName, overwrite);
        String autoJoinConfig = "allowParticipantAutoJoin=true";
        clusterSetup.setConfig(HelixConfigScope.ConfigScopeProperty.CLUSTER, clusterName, autoJoinConfig);
    }

    public static String getHelixInstanceName(String namePrefix, int instanceId) {
        return namePrefix + "_" + instanceId;
    }

    @VisibleForTesting
    public static void sendUserDefinedMessage(String messageSubType, String messageVal, String messageId, InstanceType instanceType, HelixManager helixManager, Logger logger) {
        Criteria criteria = new Criteria();
        criteria.setInstanceName("%");
        criteria.setResource("%");
        criteria.setPartition("%");
        criteria.setPartitionState("%");
        criteria.setRecipientInstanceType(instanceType);
        criteria.setSessionSpecific(true);
        Message message = new Message(Message.MessageType.USER_DEFINE_MSG.toString(), messageId);
        message.setMsgSubType(messageSubType);
        message.setAttribute(Message.Attributes.INNER_MESSAGE, messageVal);
        message.setMsgState(Message.MessageState.NEW);
        message.setTgtSessionId("*");
        int messagesSent = helixManager.getMessagingService().send(criteria, message);
        if (messagesSent == 0) {
            logger.error(String.format("Failed to send the %s message to the participants", message));
        }
    }
}

