/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.utils;

import avro.shaded.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.gobblin.runtime.api.FlowEdge;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.service.modules.flow.LoadBasedFlowEdgeImpl;
import org.apache.gobblin.service.modules.utils.DistancedNode;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPathUtils {
    private static final Logger log = LoggerFactory.getLogger(FindPathUtils.class);

    @VisibleForTesting
    public static List<FlowEdge> dijkstraBasedPathFindingHelper(ServiceNode sourceNode, ServiceNode targetNode, DirectedWeightedMultigraph<ServiceNode, FlowEdge> weightedGraph) {
        HashMap shortestPath = new HashMap();
        HashMap<DistancedNode<ServiceNode>, Double> shortestDist = new HashMap<DistancedNode<ServiceNode>, Double>();
        PriorityQueue<DistancedNode> pq = new PriorityQueue<DistancedNode>(new Comparator<DistancedNode>(){

            @Override
            public int compare(DistancedNode o1, DistancedNode o2) {
                if (o1.getDistToSrc() < o2.getDistToSrc()) {
                    return -1;
                }
                return 1;
            }
        });
        pq.add(new DistancedNode<ServiceNode>(sourceNode, 0.0));
        HashSet<FlowEdge> visitedEdge = new HashSet<FlowEdge>();
        while (!pq.isEmpty()) {
            DistancedNode node = pq.poll();
            if (node.getNode().getNodeName().equals(targetNode.getNodeName())) {
                return (List)shortestPath.get(node);
            }
            Set outgoingEdges = weightedGraph.outgoingEdgesOf(node.getNode());
            for (FlowEdge outGoingEdge : outgoingEdges) {
                double newDist;
                if (visitedEdge.contains(outGoingEdge)) continue;
                DistancedNode<ServiceNode> adjacentNode = new DistancedNode<ServiceNode>((ServiceNode)weightedGraph.getEdgeTarget((Object)outGoingEdge));
                if (shortestDist.containsKey(adjacentNode)) {
                    adjacentNode.setDistToSrc((Double)shortestDist.get(adjacentNode));
                }
                if ((newDist = node.getDistToSrc() + ((LoadBasedFlowEdgeImpl)outGoingEdge).getEdgeLoad()) < adjacentNode.getDistToSrc()) {
                    if (pq.contains(adjacentNode)) {
                        pq.remove(adjacentNode);
                    }
                    ArrayList<FlowEdge> path = shortestPath.containsKey(node) ? new ArrayList<FlowEdge>((Collection)shortestPath.get(node)) : new ArrayList();
                    path.add(outGoingEdge);
                    shortestPath.put(adjacentNode, path);
                    shortestDist.put(adjacentNode, newDist);
                    adjacentNode.setDistToSrc(newDist);
                    pq.add(adjacentNode);
                }
                visitedEdge.add(outGoingEdge);
            }
        }
        log.error("No path found");
        return new ArrayList<FlowEdge>();
    }
}

