/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Service;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.linkedin.data.template.StringMap;
import com.linkedin.r2.RemoteInvocationException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.restli.EmbeddedRestliServer;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.runtime.app.ApplicationException;
import org.apache.gobblin.runtime.app.ApplicationLauncher;
import org.apache.gobblin.runtime.app.ServiceBasedAppLauncher;
import org.apache.gobblin.runtime.spec_catalog.FlowCatalog;
import org.apache.gobblin.runtime.spec_catalog.TopologyCatalog;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.service.FlowConfig;
import org.apache.gobblin.service.FlowConfigClient;
import org.apache.gobblin.service.FlowConfigsResource;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.Schedule;
import org.apache.gobblin.service.modules.core.GitConfigMonitor;
import org.apache.gobblin.service.modules.orchestration.Orchestrator;
import org.apache.gobblin.service.modules.scheduler.GobblinServiceJobScheduler;
import org.apache.gobblin.service.modules.topology.TopologySpecFactory;
import org.apache.gobblin.service.modules.utils.HelixUtils;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinServiceManager
implements ApplicationLauncher,
StandardMetricsBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinServiceManager.class);
    protected final ServiceBasedAppLauncher serviceLauncher;
    private volatile boolean stopInProgress = false;
    protected final EventBus eventBus = new EventBus(GobblinServiceManager.class.getSimpleName());
    protected final FileSystem fs;
    protected final Path serviceWorkDir;
    protected final String serviceId;
    protected final boolean isTopologyCatalogEnabled;
    protected final boolean isFlowCatalogEnabled;
    protected final boolean isSchedulerEnabled;
    protected final boolean isRestLIServerEnabled;
    protected final boolean isTopologySpecFactoryEnabled;
    protected final boolean isGitConfigMonitorEnabled;
    protected TopologyCatalog topologyCatalog;
    protected FlowCatalog flowCatalog;
    protected GobblinServiceJobScheduler scheduler;
    protected Orchestrator orchestrator;
    protected EmbeddedRestliServer restliServer;
    protected TopologySpecFactory topologySpecFactory;
    protected Optional<HelixManager> helixManager;
    protected ClassAliasResolver<TopologySpecFactory> aliasResolver;
    protected GitConfigMonitor gitConfigMonitor;
    protected Config config;
    private final MetricContext metricContext;
    private final Metrics metrics;

    public GobblinServiceManager(String serviceName, String serviceId, Config config, Optional<Path> serviceWorkDirOptional) throws Exception {
        Optional zkConnectionString;
        Properties properties = ConfigUtils.configToProperties((Config)config);
        if (!properties.contains("app.stop.time.seconds")) {
            properties.setProperty("app.stop.time.seconds", Long.toString(300L));
        }
        this.config = config;
        this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), this.getClass());
        this.metrics = new Metrics(this.metricContext, this.config);
        this.serviceId = serviceId;
        this.serviceLauncher = new ServiceBasedAppLauncher(properties, serviceName);
        this.fs = this.buildFileSystem(config);
        this.serviceWorkDir = serviceWorkDirOptional.isPresent() ? (Path)serviceWorkDirOptional.get() : this.getServiceWorkDirPath(this.fs, serviceName, serviceId);
        this.isTopologyCatalogEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.topologyCatalog.enabled", (boolean)true);
        if (this.isTopologyCatalogEnabled) {
            this.topologyCatalog = new TopologyCatalog(config, Optional.of((Object)LOGGER));
            this.serviceLauncher.addService((Service)this.topologyCatalog);
        }
        this.isFlowCatalogEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.flowCatalog.enabled", (boolean)true);
        if (this.isFlowCatalogEnabled) {
            this.flowCatalog = new FlowCatalog(config, Optional.of((Object)LOGGER));
            this.serviceLauncher.addService((Service)this.flowCatalog);
            this.isGitConfigMonitorEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.gitConfigMonitor.enabled", (boolean)false);
            if (this.isGitConfigMonitorEnabled) {
                this.gitConfigMonitor = new GitConfigMonitor(config, this.flowCatalog);
                this.serviceLauncher.addService((Service)this.gitConfigMonitor);
            }
        } else {
            this.isGitConfigMonitorEnabled = false;
        }
        if ((zkConnectionString = Optional.fromNullable((Object)ConfigUtils.getString((Config)config, (String)"gobblin.service.zk.connection.string", null))).isPresent()) {
            LOGGER.info("Using ZooKeeper connection string: " + zkConnectionString);
            this.helixManager = Optional.fromNullable((Object)this.buildHelixManager(config, (String)zkConnectionString.get()));
        } else {
            LOGGER.info("No ZooKeeper connection string. Running in single instance mode.");
            this.helixManager = Optional.absent();
        }
        this.isSchedulerEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.scheduler.enabled", (boolean)true);
        if (this.isSchedulerEnabled) {
            this.orchestrator = new Orchestrator(config, (Optional<TopologyCatalog>)Optional.of((Object)this.topologyCatalog), (Optional<Logger>)Optional.of((Object)LOGGER));
            SchedulerService schedulerService = new SchedulerService(properties);
            this.scheduler = new GobblinServiceJobScheduler(config, this.helixManager, (Optional<FlowCatalog>)Optional.of((Object)this.flowCatalog), (Optional<TopologyCatalog>)Optional.of((Object)this.topologyCatalog), this.orchestrator, schedulerService, (Optional<Logger>)Optional.of((Object)LOGGER));
            this.serviceLauncher.addService((Service)schedulerService);
            this.serviceLauncher.addService((Service)this.scheduler);
        }
        this.isRestLIServerEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.restliServer.enabled", (boolean)true);
        if (this.isRestLIServerEnabled) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

                public void configure(Binder binder) {
                    binder.bind(FlowCatalog.class).annotatedWith((Annotation)Names.named((String)"flowCatalog")).toInstance((Object)GobblinServiceManager.this.flowCatalog);
                    binder.bindConstant().annotatedWith((Annotation)Names.named((String)"readyToUse")).to(Boolean.TRUE.booleanValue());
                }
            }});
            this.restliServer = EmbeddedRestliServer.builder().resources((Collection)Lists.newArrayList((Object[])new Class[]{FlowConfigsResource.class})).injector(injector).build();
            this.serviceLauncher.addService((Service)this.restliServer);
        }
        if (this.isSchedulerEnabled) {
            this.flowCatalog.addListener((SpecCatalogListener)this.scheduler);
        }
        this.isTopologySpecFactoryEnabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.topologySpecFactory.enabled", (boolean)true);
        if (this.isTopologySpecFactoryEnabled) {
            this.aliasResolver = new ClassAliasResolver(TopologySpecFactory.class);
            String topologySpecFactoryClass = "org.apache.gobblin.service.modules.topology.ConfigBasedTopologySpecFactory";
            if (config.hasPath("topologySpecFactory.class")) {
                topologySpecFactoryClass = config.getString("topologySpecFactory.class");
            }
            try {
                LOGGER.info("Using TopologySpecFactory class name/alias " + topologySpecFactoryClass);
                this.topologySpecFactory = (TopologySpecFactory)ConstructorUtils.invokeConstructor(Class.forName(this.aliasResolver.resolve(topologySpecFactoryClass)), (Object[])new Object[]{config});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isLeader() {
        return !this.helixManager.isPresent() || ((HelixManager)this.helixManager.get()).isLeader();
    }

    private HelixManager buildHelixManager(Config config, String zkConnectionString) {
        String helixClusterName = config.getString("gobblin.service.helix.cluster.name");
        String helixInstanceName = ConfigUtils.getString((Config)config, (String)"gobblin.service.helixInstanceName", (String)GobblinServiceManager.class.getSimpleName());
        LOGGER.info("Creating Helix cluster if not already present [overwrite = false]: " + zkConnectionString);
        HelixUtils.createGobblinHelixCluster(zkConnectionString, helixClusterName, false);
        return HelixUtils.buildHelixManager(helixInstanceName, helixClusterName, zkConnectionString);
    }

    private FileSystem buildFileSystem(Config config) throws IOException {
        return config.hasPath("fs.uri") ? FileSystem.get((URI)URI.create(config.getString("fs.uri")), (Configuration)new Configuration()) : FileSystem.get((Configuration)new Configuration());
    }

    private Path getServiceWorkDirPath(FileSystem fs, String serviceName, String serviceId) {
        return new Path(fs.getHomeDirectory(), serviceName + "/" + serviceId);
    }

    private void handleLeadershipChange(NotificationContext changeContext) {
        if (this.helixManager.isPresent() && ((HelixManager)this.helixManager.get()).isLeader()) {
            LOGGER.info("Leader notification for {} HM.isLeader {}", (Object)((HelixManager)this.helixManager.get()).getInstanceName(), (Object)((HelixManager)this.helixManager.get()).isLeader());
            if (this.isSchedulerEnabled) {
                LOGGER.info("Gobblin Service is now running in master instance mode, enabling Scheduler.");
                this.scheduler.setActive(true);
            }
            if (this.isGitConfigMonitorEnabled) {
                this.gitConfigMonitor.setActive(true);
            }
        } else if (this.helixManager.isPresent()) {
            LOGGER.info("Leader lost notification for {} HM.isLeader {}", (Object)((HelixManager)this.helixManager.get()).getInstanceName(), (Object)((HelixManager)this.helixManager.get()).isLeader());
            if (this.isSchedulerEnabled) {
                LOGGER.info("Gobblin Service is now running in slave instance mode, disabling Scheduler.");
                this.scheduler.setActive(false);
            }
            if (this.isGitConfigMonitorEnabled) {
                this.gitConfigMonitor.setActive(false);
            }
        }
    }

    public void start() throws ApplicationException {
        LOGGER.info("[Init] Starting the Gobblin Service Manager");
        if (this.helixManager.isPresent()) {
            this.connectHelixManager();
        }
        this.eventBus.register((Object)this);
        this.serviceLauncher.start();
        if (this.helixManager.isPresent()) {
            ((HelixManager)this.helixManager.get()).addControllerListener(new ControllerChangeListener(){

                public void onControllerChange(NotificationContext changeContext) {
                    GobblinServiceManager.this.handleLeadershipChange(changeContext);
                }
            });
            if (((HelixManager)this.helixManager.get()).isLeader()) {
                if (this.isSchedulerEnabled) {
                    LOGGER.info("[Init] Gobblin Service is running in master instance mode, enabling Scheduler.");
                    this.scheduler.setActive(true);
                }
                if (this.isGitConfigMonitorEnabled) {
                    this.gitConfigMonitor.setActive(true);
                }
            } else if (this.isSchedulerEnabled) {
                LOGGER.info("[Init] Gobblin Service is running in slave instance mode, not enabling Scheduler.");
            }
        } else {
            LOGGER.info("[Init] Gobblin Service is running in single instance mode, enabling Scheduler.");
            this.scheduler.setActive(true);
            if (this.isGitConfigMonitorEnabled) {
                this.gitConfigMonitor.setActive(true);
            }
        }
        if (this.isTopologySpecFactoryEnabled) {
            Collection<TopologySpec> topologySpecs = this.topologySpecFactory.getTopologies();
            for (TopologySpec topologySpec : topologySpecs) {
                this.topologyCatalog.put((Spec)topologySpec);
            }
        }
        if (this.isSchedulerEnabled) {
            this.topologyCatalog.addListener((SpecCatalogListener)this.orchestrator);
        }
        this.topologyCatalog.getInitComplete().countDown();
    }

    public void stop() throws ApplicationException {
        if (this.stopInProgress) {
            return;
        }
        LOGGER.info("Stopping the Gobblin Service Manager");
        this.stopInProgress = true;
        try {
            this.serviceLauncher.stop();
        }
        catch (ApplicationException ae) {
            LOGGER.error("Error while stopping Gobblin Service Manager", (Throwable)ae);
        }
        finally {
            this.disconnectHelixManager();
        }
    }

    @VisibleForTesting
    void connectHelixManager() {
        try {
            if (this.helixManager.isPresent()) {
                ((HelixManager)this.helixManager.get()).connect();
                ((HelixManager)this.helixManager.get()).getMessagingService().registerMessageHandlerFactory(Message.MessageType.USER_DEFINE_MSG.toString(), this.getUserDefinedMessageHandlerFactory());
            }
        }
        catch (Exception e) {
            LOGGER.error("HelixManager failed to connect", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected MessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ControllerUserDefinedMessageHandlerFactory(this.flowCatalog, this.scheduler);
    }

    @VisibleForTesting
    void disconnectHelixManager() {
        if (this.isHelixManagerConnected() && this.helixManager.isPresent()) {
            ((HelixManager)this.helixManager.get()).disconnect();
        }
    }

    @VisibleForTesting
    boolean isHelixManagerConnected() {
        return this.helixManager.isPresent() && ((HelixManager)this.helixManager.get()).isConnected();
    }

    public void close() throws IOException {
        this.serviceLauncher.close();
    }

    public StandardMetricsBridge.StandardMetrics getStandardMetrics() {
        return this.metrics;
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return false;
    }

    private static String getServiceId() {
        return "1";
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption("a", "service_name", true, "Gobblin application name");
        return options;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(GobblinServiceManager.class.getSimpleName(), options);
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinServiceManager.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!cmd.hasOption("service_name")) {
                GobblinServiceManager.printUsage(options);
                System.exit(1);
            }
            boolean isTestMode = false;
            if (cmd.hasOption("test_mode")) {
                isTestMode = Boolean.parseBoolean(cmd.getOptionValue("test_mode", "false"));
            }
            Config config = ConfigFactory.load();
            try (GobblinServiceManager gobblinServiceManager = new GobblinServiceManager(cmd.getOptionValue("service_name"), GobblinServiceManager.getServiceId(), config, (Optional<Path>)Optional.absent());){
                gobblinServiceManager.start();
                if (isTestMode) {
                    GobblinServiceManager.testGobblinService(gobblinServiceManager);
                }
            }
        }
        catch (ParseException pe) {
            GobblinServiceManager.printUsage(options);
            System.exit(1);
        }
    }

    private static void testGobblinService(GobblinServiceManager gobblinServiceManager) {
        FlowConfigClient client = new FlowConfigClient(String.format("http://localhost:%s/", gobblinServiceManager.restliServer.getPort()));
        HashMap flowProperties = Maps.newHashMap();
        flowProperties.put("param1", "value1");
        String TEST_GROUP_NAME = "testGroup1";
        String TEST_FLOW_NAME = "testFlow1";
        String TEST_SCHEDULE = "0 1/0 * ? * *";
        String TEST_TEMPLATE_URI = "FS:///templates/test.template";
        FlowConfig flowConfig = new FlowConfig().setId(new FlowId().setFlowGroup("testGroup1").setFlowName("testFlow1")).setTemplateUris("FS:///templates/test.template").setSchedule(new Schedule().setCronSchedule("0 1/0 * ? * *").setRunImmediately(true)).setProperties(new StringMap((Map)flowProperties));
        try {
            client.createFlowConfig(flowConfig);
        }
        catch (RemoteInvocationException e) {
            throw new RuntimeException(e);
        }
    }

    public FlowCatalog getFlowCatalog() {
        return this.flowCatalog;
    }

    public GobblinServiceJobScheduler getScheduler() {
        return this.scheduler;
    }

    public Config getConfig() {
        return this.config;
    }

    private static class ControllerUserDefinedMessageHandlerFactory
    implements MessageHandlerFactory {
        private FlowCatalog flowCatalog;
        private GobblinServiceJobScheduler jobScheduler;

        public ControllerUserDefinedMessageHandlerFactory(FlowCatalog flowCatalog, GobblinServiceJobScheduler jobScheduler) {
            this.flowCatalog = flowCatalog;
            this.jobScheduler = jobScheduler;
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ControllerUserDefinedMessageHandler(this.flowCatalog, this.jobScheduler, message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private static class ControllerUserDefinedMessageHandler
        extends MessageHandler {
            private FlowCatalog flowCatalog;
            private GobblinServiceJobScheduler jobScheduler;

            public ControllerUserDefinedMessageHandler(FlowCatalog flowCatalog, GobblinServiceJobScheduler jobScheduler, Message message, NotificationContext context) {
                super(message, context);
                this.flowCatalog = flowCatalog;
                this.jobScheduler = jobScheduler;
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                String flowSpecUri;
                if (this.jobScheduler.isActive()) {
                    flowSpecUri = this._message.getAttribute(Message.Attributes.INNER_MESSAGE);
                    LOGGER.info("ControllerUserDefinedMessage received : {}, type {}", (Object)flowSpecUri, (Object)this._message.getMsgSubType());
                    try {
                        if (this._message.getMsgSubType().equals("FLOWSPEC_ADD")) {
                            Spec spec = this.flowCatalog.getSpec(new URI(flowSpecUri));
                            this.jobScheduler.onAddSpec(spec);
                        } else if (this._message.getMsgSubType().equals("FLOWSPEC_REMOVE")) {
                            List flowSpecUriParts = Splitter.on((String)":").omitEmptyStrings().trimResults().splitToList((CharSequence)flowSpecUri);
                            this.jobScheduler.onDeleteSpec(new URI((String)flowSpecUriParts.get(0)), (String)flowSpecUriParts.get(1));
                        } else if (this._message.getMsgSubType().equals("FLOWSPEC_UPDATE")) {
                            Spec spec = this.flowCatalog.getSpec(new URI(flowSpecUri));
                            this.jobScheduler.onUpdateSpec(spec);
                        }
                    }
                    catch (URISyntaxException | SpecNotFoundException e) {
                        LOGGER.error("Cannot process Helix message for flowSpecUri: " + flowSpecUri, e);
                    }
                } else {
                    flowSpecUri = this._message.getAttribute(Message.Attributes.INNER_MESSAGE);
                    LOGGER.info("ControllerUserDefinedMessage received but ignored due to not in active mode: {}, type {}", (Object)flowSpecUri, (Object)this._message.getMsgSubType());
                }
                HelixTaskResult helixTaskResult = new HelixTaskResult();
                helixTaskResult.setSuccess(true);
                return helixTaskResult;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }

    private class Metrics
    extends StandardMetricsBridge.StandardMetrics {
        public static final String SERVICE_LEADERSHIP_CHANGE = "serviceLeadershipChange";
        private ContextAwareHistogram serviceLeadershipChange;

        public Metrics(MetricContext metricContext, Config config) {
            int timeWindowSizeInMinutes = ConfigUtils.getInt((Config)config, (String)"metrics.timer.window.size.in.minutes", (Integer)15);
            this.serviceLeadershipChange = metricContext.contextAwareHistogram(SERVICE_LEADERSHIP_CHANGE, (long)timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.contextAwareMetrics.add(this.serviceLeadershipChange);
        }
    }
}

