/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.patch.request;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.transform.Escaper;
import com.linkedin.data.transform.patch.request.PatchOperation;
import com.linkedin.util.ArgumentUtil;
import java.util.List;

public class PatchTree {
    private DataMap _representation;

    public PatchTree() {
        this._representation = new DataMap();
    }

    public PatchTree(DataMap rep) {
        ArgumentUtil.notNull((Object)rep, (String)"rep");
        this._representation = rep;
    }

    public void addOperation(PathSpec path, PatchOperation op) {
        List segments = path.getPathComponents();
        DataMap map = this._representation;
        for (int ii = 0; ii < segments.size() - 1; ++ii) {
            String segment = Escaper.escapePathSegment((String)segments.get(ii));
            Object o = map.get((Object)segment);
            if (o == null) {
                DataMap childMap = new DataMap();
                map.put((Object)segment, (Object)childMap);
                map = childMap;
                continue;
            }
            map = (DataMap)o;
        }
        String lastSegment = Escaper.escapePathSegment((String)segments.get(segments.size() - 1));
        op.store(map, lastSegment);
    }

    public DataMap getDataMap() {
        return this._representation;
    }

    public String toString() {
        return this._representation.toString();
    }
}

