/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

public enum NodeMode {
    SHOW_LOW(0, 3),
    HIDE_LOW(1, 2),
    SHOW_HIGH(2, 1),
    HIDE_HIGH(3, 0);

    private final Integer _priority;
    private final Integer _representation;

    private NodeMode(int priority, Integer representation) {
        this._priority = priority;
        this._representation = representation;
    }

    public Integer representation() {
        return this._representation;
    }

    public Integer priority() {
        return this._priority;
    }

    public static NodeMode fromRepresentation(Integer r) {
        switch (r) {
            case 0: {
                return HIDE_HIGH;
            }
            case 1: {
                return SHOW_HIGH;
            }
            case 2: {
                return HIDE_LOW;
            }
            case 3: {
                return SHOW_LOW;
            }
        }
        return null;
    }
}

